#ifndef RFM95W_H
#define RFM95W_H

#include "mbed.h"
#include "sx1276-hal.h"
#include "ESP8266.h"
#include "Board.h"
#include "SD.h"

#define GATEWAY_ID 1    // Adresa Access pointu

////////////////////////////////////////////////////////////////////////////////

/* Set this flag to '1' to use the LoRa modulation or to '0' to use FSK modulation */
#define USE_MODEM_LORA  1
#define USE_MODEM_FSK   !USE_MODEM_LORA

#define RF_FREQUENCY                                    869525000 //868000000 // Hz
#define TX_OUTPUT_POWER                                 20        // 20 dBm

#if USE_MODEM_LORA == 1
// Max range, slow data rate = BW=125, CR=4/5, SF=12
#define LORA_BANDWIDTH                              1           // [0: 125 kHz,
                                                                //  1: 250 kHz,
                                                                //  2: 500 kHz,
                                                                //  3: Reserved]
#define LORA_SPREADING_FACTOR                       12          // [SF7..SF12]
#define LORA_CODINGRATE                             1           // [1: 4/5,
                                                                //  2: 4/6,
                                                                //  3: 4/7,
                                                                //  4: 4/8]
#define LORA_PREAMBLE_LENGTH                        8           // Same for Tx and Rx
#define LORA_SYMBOL_TIMEOUT                         5           // Symbols
#define LORA_FIX_LENGTH_PAYLOAD_ON                  false
#define LORA_FHSS_ENABLED                           false
#define LORA_NB_SYMB_HOP                            4
#define LORA_IQ_INVERSION_ON                        false
#define LORA_CRC_ENABLED                            true

#elif USE_MODEM_FSK == 1

#define FSK_FDEV                                    25000     // Hz
#define FSK_DATARATE                                19200     // bps
#define FSK_BANDWIDTH                               50000     // Hz
#define FSK_AFC_BANDWIDTH                           83333     // Hz
#define FSK_PREAMBLE_LENGTH                         5         // Same for Tx and Rx
#define FSK_FIX_LENGTH_PAYLOAD_ON                   false
#define FSK_CRC_ENABLED                             true

#else
#error "Please define a modem in the compiler options."
#endif

#define RX_TIMEOUT_VALUE                                2500000     // in us                          // 3500000
#define BUFF_SIZE                                       255          // Define the payload size here   // 32
#define MAX_DEVICES                                     255
#define MAX_RESENDS                                     4
//------------------------------------------------------------------------------

class RFM95W
{
private:
    RadioEvents_t radioEvents;                /**< Radio events function pointer   */
    SX1276MB1xAS radio;                       /**< Radiovy modul   */
    DigitalOut indicationLed;                 /**< Indikacna led   */
    AnalogIn noise;
    Ticker ledTicker;
    Ticker sendTicker;
    Ticker ackTicker;

    uint8_t receivedMessage[BUFF_SIZE];
    uint8_t sendBuffer[BUFF_SIZE];
    uint8_t ack[3];
    volatile uint8_t messageNumbers[MAX_DEVICES];
    volatile uint8_t messageNumber;            /**< My message number   */
    volatile uint8_t ledState;
    volatile float timeOnAirSec;
    volatile bool receivedAck;
    volatile bool sendingAck;
    volatile uint8_t sendCounter;
    volatile bool writeDataToSD;

    float CalculateRandomTime();
    void InitRandom();
    void OnLedTick();
    void SendMessage();
    void SendAck(uint8_t addr, uint8_t messageNumber);
    void OnCheckAck();
    void OnSendAgain();
public:
    RFM95W();
    void Init();
    void OnTxDone( void );
    void OnRxDone( uint8_t *payload, uint16_t size, int16_t rssi, int8_t snr );
    void OnTxTimeout( void );
    void OnRxTimeout( void );
    void OnRxError( void );
    void OnCadDone( bool channelActivityDetected );
    void SendValue(uint8_t addr, float value);
    void SendValue(uint8_t addr, int value);
    void SendMessage(char* message);
    
    void WriteDataToSDcard();
    bool ReceivedMessage();
};
extern RFM95W rfm;

#endif