#include "mbed.h"
#include "RFM95W.h"
#include "ESP8266.h"
#include "Board.h"
#include "SD.h"
//#include "RTC.h"

DS3231 rtc(D14, D15);
//time_t epoch_time = 0;

int hour;
int minute;
int second;

int dayOfWeek;
int date;
int month;
int year; 
 

void RTC_Init()
{
    rtc.setI2Cfrequency(400000);
    //RTC.writeRegister(DS3231_Aging_Offset,0); // uncomment to set Aging Offset 1LSB = approx. 0.1 ppm according from datasheet = 0.05 ppm @ 21 °C from my measurments
    rtc.convertTemperature(); 
    int reg=rtc.readRegister(DS3231_Aging_Offset);
    if (reg>127)
        {reg=reg-256;}
  
    rtc.OSF();
//    pc.printf("Aging offset : %i\r\n",reg);       
//    pc.printf("OSF flag : %i",rtc.OSF());
//    pc.printf("\r\n");
}

void RTC_actualize()
{

    rtc.readDateTime(&dayOfWeek,&date,&month,&year,&hour,&minute,&second);
    snprintf(actual_time, 30, "%02i.%02i.%02i %02i:%02i:%02i ",date,month,year,hour,minute,second);
}

void RTC_set()
{
/*
    DS3231 rtc(D14, D15);
    rtc.setI2Cfrequency(400000);
    //RTC.writeRegister(DS3231_Aging_Offset,0); // uncomment to set Aging Offset 1LSB = approx. 0.1 ppm according from datasheet = 0.05 ppm @ 21 °C from my measurments
    rtc.convertTemperature(); 
    int reg=rtc.readRegister(DS3231_Aging_Offset);
    if (reg>127)
        {reg=reg-256;}
 
    rtc.OSF();
 */ 
/*
    ds3231_cntl_stat_t rtc_control_status = {0,0}; 
    
    rtc.set_cntl_stat_reg(rtc_control_status);
*/    
    wifi.getServerDateTime(&dayOfWeek,&date,&month,&year,&hour,&minute,&second);
    pc.printf("date time : %02i / %02i-%02i-%02i %02i:%02i:%02i",dayOfWeek,date,month,year,hour,minute,second);
    rtc.setTime(hour,minute,second);        // uncomment to set time
    rtc.setDate(dayOfWeek,date,month,year); // uncomment to set date
}

int main()
{
//    __disable_irq();    // Disable Interrupts
//    RTC_Init();
    RTC_Init();
    wifi.Init();
//    rfm.Init();
    bt.Init();
//    __enable_irq();    // Disable Interrupts

    RTC_actualize();
    rfm.Init();
//    SDcard.Read();
//    rtc.setDate(7,6,4,2019);
    while(1)
    {
        wifi.CheckSettings();
        if(rfm.ReceivedMessage())
            RTC_actualize();
//        if(wifi.actualizeActualTime())
//            RTC_set();
    }
}
/*
int main()
{
    rtcClock.Init();
    wifi.Init();
    bt.Init();
    rfm.Init();
    while(1)
    {
        wifi.CheckSettings();
    }
}
*/
/*
int main()
{
    DS3231 rtc(D14,D15);

    
    rtc.setI2Cfrequency(400000);
    //RTC.writeRegister(DS3231_Aging_Offset,0); // uncomment to set Aging Offset 1LSB = approx. 0.1 ppm according from datasheet = 0.05 ppm @ 21 °C from my measurments
    rtc.convertTemperature(); 
    int reg=rtc.readRegister(DS3231_Aging_Offset);
    if (reg>127)
        {reg=reg-256;}

    pc.printf("Aging offset : %i\r\n",reg);       
    pc.printf("OSF flag : %i",rtc.OSF());
    pc.printf("\r\n");
    
     rtc.readDate(&date,&month,&year);
     pc.printf("date : %02i-%02i-%02i",date,month,year);
     pc.printf("\r\n");
     
     //RTC.setTime(19,48,45); // uncomment to set time
     
     rtc.readTime(&hour,&minute,&second);
     pc.printf("time : %02i:%02i:%02i",hour,minute,second);
     pc.printf("\r\n");
     
     //RTC.setDate(6,22,12,2012); // uncomment to set date

     rtc.readDateTime(&dayOfWeek,&date,&month,&year,&hour,&minute,&second);
     pc.printf("date time : %i / %02i-%02i-%02i %02i:%02i:%02i",dayOfWeek,date,month,year,hour,minute,second);
     pc.printf("\r\n");
     
     pc.printf("temperature :%6.2f",rtc.readTemp());
     pc.printf("\r\n");

    wifi.Init();
    bt.Init();
    rfm.Init();
    while(1)
    {
        wifi.CheckSettings();
        rtc.readDateTime(&dayOfWeek,&date,&month,&year,&hour,&minute,&second);
        snprintf(actual_time, 30, "%02i.%02i.%02i %02i:%02i:%02i |",date,month,year,hour,minute,second);
//        pc.printf("%02i.%02i.%02i %02i:%02i:%02i\r\n",date,month,year,hour,minute,second);
        wait(0.5);
    }
}
*/

/*
int main()
{
    wifi.Init();
    bt.Init();
    rfm.Init();
//    SDcard.Init();
//    Ds3231 rtc(D14, D15);    

    while(1) {
        wifi.CheckSettings();
        epoch_time = rtc.get_epoch();
//        pc.printf("\nTime as a basic string = %s \r\n", ctime(&epoch_time));
        wait(0.5);
//        rfm.WriteDataToSDcard();
    }
}
*/

/*
int main()
{    
    time_t time;
    while(1)
    {
        epoch_time = rtc.get_epoch();
        pc.printf("\nTime as a basic string = %s \r\n", ctime(&epoch_time));
        wait(1);
    }
    
}
*/


/*
int main(void)
{
    wifi.Init();
    bt.Init();
    rfm.Init();
//    SDcard.Init();
//    sd.mount();
    pc.printf("Start! \r\n");
//    mon();
//    create_file();
//    init_card();

    //rtc object
    Ds3231 rtc(D14, D15); 
    
    time_t epoch_time;
    
    //DS3231 rtc variables
    
    //default, use bit masks in ds3231.h for desired operation
//    ds3231_cntl_stat_t rtc_control_status = {0,0}; 
//    ds3231_time_t rtc_time;
//    ds3231_calendar_t rtc_calendar;
    
//    rtc.set_cntl_stat_reg(rtc_control_status);
    char buffer[32];
    while(1)
    {
//        FILE *myLogFile;
//        pc.printf("%c[2J", ESC); //clear screen
//        pc.printf("%c[H", ESC); //move cursor to Home
        
        //new epoch time fx
        epoch_time = rtc.get_epoch();
        
        pc.printf("\nTime as seconds since January 1, 1970 = %d\r\n", epoch_time);
        
        pc.printf("\nTime as a basic string = %s \r\n", ctime(&epoch_time));
 
        strftime(buffer, 32, "%I:%M %p\n", localtime(&epoch_time));
        pc.printf("\nTime as a custom formatted string = %s \r\n", buffer);
      
        if (myLogFile)
            fclose(myLogFile);
        myLogFile = fopen("/sd/DATA_LOG.txt", "a");
        pc.printf("try to open\r\n");
        if (myLogFile == NULL)
        {
            pc.printf("ERROR: failed to open the log file for writing!\r\n");
        }
        else
        {
            fprintf(myLogFile," %s" ,ctime(&epoch_time));
//            fclose(myLogFile);
//            free(myLogFile);
        }
        fclose(myLogFile);

        wait(2);
    }
}

*/

