#include "HC05.h"

const char* BT_ALIVE_RESPONSE = "~~LoRa Gateway~~";
HC05 bt(BT_TX,BT_RX);


HC05::HC05(PinName tx, PinName rx)
    : btUart(tx,rx,BAUDRATE)
{
    ClearBuffer();
};

void HC05::Init()
{
    ClearBuffer();
    btUart.attach(callback(this,&HC05::RxBtInterrupt), Serial::RxIrq);
};

void HC05::ClearBuffer()
{
    memset(buffer, '\0', sizeof(buffer));
    pt = 0;
};

void HC05::RxBtInterrupt()
{
    char c  = btUart.getc();
    buffer[pt++] = c;
    if(pt >= BUFFERSIZE - 1)
        ClearBuffer();

    if(c =='\n') {
        if( strncmp( ( const char* )buffer, "~~~", 3 ) == 0 )
            btUart.printf("%s\r\n", BT_ALIVE_RESPONSE);

        if( strncmp( ( const char* )buffer, "AT+SAVETRANSLINK=", 17 ) == 0 )
            wifi.SetIpOfServer(buffer);

        if( strncmp( ( const char* )buffer, "AT+CWJAP=", 9 ) == 0 )
            wifi.SetWiFiConnection(buffer);

        ClearBuffer();
    }
};

void HC05::Send(char* message)
{
    btUart.printf("%s\r\n",message);
};