#ifndef ESP8266_H
#define ESP8266_H

#include "mbed.h"
#include "RFM95W.h"
#include "Board.h"
#include "HC05.h"
//#include "RTC.h"
//#include "SD.h"

#define BUFFER_SIZE 1024
#define SETTING_SIZE 64

class ESP8266
{
private:
    Serial wifiUart;
    DigitalInOut wifiReset;
    Timer responseTimer;
    Ticker setTicker;
    char buffer[BUFFER_SIZE];
    char serverIpAddress[SETTING_SIZE];            // ip adresa servera, command
    char wifiSettings[SETTING_SIZE];               // wifi connection
    volatile uint16_t pt;
    char* response;
    volatile bool okResponse;
    volatile bool receiveResponse;
    volatile bool setServerIp;
    volatile bool setWifiSettings;
    
    volatile bool actualizeTime;
    int hour;
    int minute;
    int second;
    int dayOfWeek;
    int date;
    int month;
    int year;  
    
    void ClearBuffer();
    void RxWifiInterrupt();
    void convert_time();
public:
    ESP8266(PinName tx, PinName rx, PinName reset);
    ESP8266();
    void Init();
    void SendCommand(char* command, char* answer ,int timeoutMs);
    void SetIpOfServer(char* command);
    void SetWiFiConnection(char* command);
    void SendMessage(char* message);
    void Test();
    void CheckSettings();
    void ConfirmReceivedAck(uint8_t from);
    
    void getServerDateTime(int *w, int *d, int *mo, int *y, int *h, int *m, int *s);
    bool actualizeActualTime();
};

extern ESP8266 wifi;

#endif