#include "RFM95W.h"

RFM95W rfm;

//--------------------------- Callback funkcie ---------------------------------
void TxDone(void)
{
    rfm.OnTxDone();
};

void RxDone( uint8_t *payload, uint16_t size, int16_t rssi, int8_t snr )
{
    rfm.OnRxDone(payload,size,rssi,snr);
};

void TxTimeout(void)
{
    rfm.OnTxTimeout();
};

void RxTimeout(void)
{
    rfm.OnRxTimeout();
};

void RxError(void)
{
    rfm.OnRxError();
};

void CadDone(bool channelActivityDetected)
{
    rfm.OnCadDone(channelActivityDetected);
};
//------------------------------------------------------------------------------

RFM95W::RFM95W()
    : radio(NULL),
      indicationLed(LED_PIN),
      noise(NOISE_PIN)
{
    for(uint16_t i=0; i<MAX_DEVICES; i++)
        messageNumbers[i]=NULL;
    memset(receivedMessage, '\0', sizeof(receivedMessage));
    ledState = 0;
    timeOnAirSec = 0.3;
    indicationLed = 1;
    messageNumber = GATEWAY_ID;
    sendCounter = 0;
    receivedAck = false;
    writeDataToSD = false;
};

void RFM95W::OnLedTick()
{
    if(ledState<4) {
        indicationLed = !indicationLed;
    } else {
        ledState = 0;
        indicationLed = 1;
        ledTicker.detach();
    }
    ledState++;
}

void RFM95W::SendMessage()
{
    snprintf((char *)ack, 3, "%c%c%c",GATEWAY_ID, sendBuffer[0], messageNumber);
    radio.Send( sendBuffer, 30 );
}

void RFM95W::SendAck(uint8_t addr, uint8_t messageNumber)
{
    uint8_t ack[3];
    snprintf((char *)ack, sizeof(ack), "%c%c%c", addr, GATEWAY_ID, messageNumber);
//    pc.printf("Sending Ack : %s \r\n",ack);
    pc.printf("Sending Ack : %d \r\n",addr);
    radio.Send(ack, 3);
};

float RFM95W::CalculateRandomTime()
{
    uint8_t number = rand() % 1500;;
    while(number == 0) {
        number = rand() % 1500;
    }
    return (timeOnAirSec * (number / 500.0));
};

void RFM95W::OnCheckAck()
{
    if((receivedAck == false) && (sendCounter < MAX_RESENDS))
    {
        sendTicker.detach();
        sendTicker.attach(callback(this,&RFM95W::OnSendAgain), CalculateRandomTime());
    }
    else if((receivedAck == false) && (sendCounter >= MAX_RESENDS)) {
        messageNumber++;
        if(messageNumber>255)
            messageNumber = 0;
    }
    ackTicker.detach();
};

void RFM95W::OnSendAgain()
{
    pc.printf("On send again \r\n");
    SendMessage();
    sendCounter++;
    sendTicker.detach();
};

void RFM95W::OnTxDone( void )
{
    radio.Sleep();
    if(sendingAck)
    {
        sendingAck = false;
    }
    else {
        pc.printf("OnTxDone !\r\n");
        receivedAck = false;
        ackTicker.detach();
        ackTicker.attach(callback(this,&RFM95W::OnCheckAck),timeOnAirSec*3);
    }
    radio.Rx(0);
};

void RFM95W::OnRxDone( uint8_t *payload, uint16_t size, int16_t rssi, int8_t snr )
{
    radio.Sleep();
    if(payload[0] == GATEWAY_ID) {
        uint8_t msgFrom = payload[1];
        indicationLed=0;
        ledTicker.detach();
        ledTicker.attach(callback(this,&RFM95W::OnLedTick), 0.05);
        if((size == 3) && (strncmp( ( const char* )payload, ( const char* )ack, 3 ) == 0) ) {
            receivedAck = true;
            wifi.ConfirmReceivedAck(msgFrom);
            pc.printf("Received Ack : %s \r\n",ack);
            messageNumber++;
            if(messageNumber>255)
                messageNumber = 0;
            radio.Rx(0);
            return;
        }
        sendingAck = true;
        SendAck(msgFrom,payload[2]);
        pc.printf("MSG from : %d , message number received= %d \r\n",msgFrom,payload[2]);
        if(payload[2] == messageNumbers[msgFrom]) {
            pc.printf("--------------------- Ta ista sprava -------------------- \r\n");
            return;
        }
        messageNumbers[msgFrom] = payload[2];
        payload[2] = 48;
        memmove(payload, payload+4, size - 4 + 1);      // orezem prve styri bajty
        snprintf((char *)receivedMessage, BUFF_SIZE, "%s|%d|%d|%d|%d|%s|",actual_time, rssi, snr, GATEWAY_ID, msgFrom, payload);
        writeDataToSD = true;
        wifi.SendMessage((char *)receivedMessage);  
        SDcard.Write((char *)receivedMessage);
        return;
    }
    radio.Rx(0);
};

void RFM95W::OnTxTimeout( void )
{
    radio.Sleep();
    Init();
};

void RFM95W::OnRxTimeout( void )
{
    radio.Sleep();
    radio.Rx(0);
};

void RFM95W::OnRxError( void )
{
    radio.Sleep();
    pc.printf("Chyba prijatia ! \r\n");
    radio.Rx(0);
};

void RFM95W::OnCadDone( bool channelActivityDetected ) {};

void RFM95W::SendValue(uint8_t addr, float value)
{
    snprintf((char *)sendBuffer, BUFF_SIZE, "%c%c%c|%.2f|",addr, GATEWAY_ID, messageNumber, value);
    sendCounter = 0;
    receivedAck = false;
    SendMessage();
};

void RFM95W::SendValue(uint8_t addr, int value)
{
    snprintf((char *)sendBuffer, BUFF_SIZE, "%c%c%c|%d|",addr, GATEWAY_ID, messageNumber, value);
    sendCounter = 0;
    receivedAck = false;
    SendMessage();
};

void RFM95W::SendMessage(char* message)
{
    snprintf((char *)sendBuffer, BUFF_SIZE, "%s", message);
    sendBuffer[0] = (char)sendBuffer[0];
    sendBuffer[1] = (char)GATEWAY_ID;
    sendBuffer[2] = (char)messageNumber;
    sendCounter = 0;
    receivedAck = false;

    pc.printf("%s",sendBuffer);
    SendMessage();
};

void RFM95W::WriteDataToSDcard()
{
    if(writeDataToSD)
    {
 //       SDcard.Write((char *)receivedMessage);
        writeDataToSD = false;
    }
}

void RFM95W::Init( void )
{
    pc.printf( "\n\n\r------- RFM95W GATEWAY -------\n\r" );
    // Initialize Radio driver
    radioEvents.TxDone = TxDone;
    radioEvents.RxDone = RxDone;
    radioEvents.RxError = RxError;
    radioEvents.TxTimeout = TxTimeout;
    radioEvents.RxTimeout = RxTimeout;
    radioEvents.CadDone = CadDone;
    radio.Init( &radioEvents );
    // verify the connection with the board
    while( radio.Read( REG_VERSION ) == 0x00  ) {
        pc.printf( "Radiovy modul nie je pripojeny!\n\r", NULL );
        wait(1);
    }
    radio.SetChannel( RF_FREQUENCY );
#if USE_MODEM_LORA == 1
    pc.printf("\n\r        > LORA Mod <        \n\n\r");
    radio.SetTxConfig( MODEM_LORA, TX_OUTPUT_POWER, 0, LORA_BANDWIDTH,
                       LORA_SPREADING_FACTOR, LORA_CODINGRATE,
                       LORA_PREAMBLE_LENGTH, LORA_FIX_LENGTH_PAYLOAD_ON,
                       LORA_CRC_ENABLED, LORA_FHSS_ENABLED, LORA_NB_SYMB_HOP,
                       LORA_IQ_INVERSION_ON, 2000000 );

    radio.SetRxConfig( MODEM_LORA, LORA_BANDWIDTH, LORA_SPREADING_FACTOR,
                       LORA_CODINGRATE, 0, LORA_PREAMBLE_LENGTH,
                       LORA_SYMBOL_TIMEOUT, LORA_FIX_LENGTH_PAYLOAD_ON, 0,
                       LORA_CRC_ENABLED, LORA_FHSS_ENABLED, LORA_NB_SYMB_HOP,
                       LORA_IQ_INVERSION_ON, true );

#elif USE_MODEM_FSK == 1

    pc.printf("\n\r        > FSK Mod <        \n\n\r");
    radio.SetTxConfig( MODEM_FSK, TX_OUTPUT_POWER, FSK_FDEV, 0,
                       FSK_DATARATE, 0,
                       FSK_PREAMBLE_LENGTH, FSK_FIX_LENGTH_PAYLOAD_ON,
                       FSK_CRC_ENABLED, 0, 0, 0, 2000000 );

    radio.SetRxConfig( MODEM_FSK, FSK_BANDWIDTH, FSK_DATARATE,
                       0, FSK_AFC_BANDWIDTH, FSK_PREAMBLE_LENGTH,
                       0, FSK_FIX_LENGTH_PAYLOAD_ON, 0, FSK_CRC_ENABLED,
                       0, 0, false, true );

#else

#error "Nie je definovany typ modemu."

#endif
    // Konfiguracia pre moznost max. vysielacieho vykonu
    uint8_t paConfig;
    paConfig = radio.Read( REG_PACONFIG );
    paConfig |= RF_PACONFIG_PASELECT_PABOOST;
    radio.Write( REG_PACONFIG, paConfig );

    pc.printf("________Start aplikacie________\r\n" );
    timeOnAirSec = (radio.TimeOnAir( MODEM_LORA, 25)/1000.0);              // time on air v ms
    pc.printf( "\n\n\r------- Time on air : %f sec. -------\n\r", timeOnAirSec);
    indicationLed = 1;
    InitRandom();
    messageNumber = rand();
    radio.Rx(0);
};

void RFM95W::InitRandom()
{
    uint32_t seed;
    uint8_t loops = 3;
    for (int i=0; i<(32*loops); i++) {
        seed ^= noise.read_u16();
        if (seed & 1<31) {
            seed <<= 1;
            seed |= 1;
        } else
            seed <<= 1;
    }
    srand(seed);
};

bool RFM95W::ReceivedMessage()
{
    if(writeDataToSD) return true;
    return false;
};
