#include "ESP8266.h"

const char* SSID = "doma2";
const char* PSWD = "0917957359";
const char* OK_MESSAGE = "OK\r\n";
const char* ERROR_MESSAGE = "ERROR\r\n";
const char* GOT_IP_MESSAGE = "WIFI GOT IP\r\n";
const char* CAN_SEND_MESSAGE = ">";
const char* SEND_OK_MESSAGE = "SEND OK\r\n";
const char* WIFI_ALIVE_RESPONSE = "~~LoRa Gateway~~\r\n";
const char* DELIMITER=":";

extern time_t epoch_time;
ESP8266 wifi(WIFI_TX, WIFI_RX, WIFI_RST);

ESP8266::ESP8266(PinName tx, PinName rx, PinName reset)
    : wifiUart(tx,rx,BAUDRATE),
      wifiReset(reset)
{
    ClearBuffer();
    okResponse = false;
    receiveResponse = false;
    setServerIp = false;
    setWifiSettings = false;
    
    actualizeTime = false;
    hour = 0;
    minute = 0;
    second = 0;
    dayOfWeek = 0;
    date = 0;
    month = 0;
    year = 0;  
};


ESP8266::ESP8266(void)
    : wifiUart(WIFI_TX,WIFI_RX,BAUDRATE),
      wifiReset(D7)
{
    ClearBuffer();
    okResponse = false;
    receiveResponse = false;
    setServerIp = false;
    setWifiSettings = false;
    
    actualizeTime = false;
    hour = 0;
    minute = 0;
    second = 0;
    dayOfWeek = 0;
    date = 0;
    month = 0;
    year = 0;  
};


void ESP8266::Init()
{
    wifiReset = 0;
    wait(0.1);
    wifiReset = 1;
    wait(0.1);
    wifiUart.attach(callback(this,&ESP8266::RxWifiInterrupt), Serial::RxIrq);
    ClearBuffer();
};

void ESP8266::RxWifiInterrupt()
{
    while (wifiUart.readable()) {
        char c = wifiUart.getc();
//        bt.putc(c);
        buffer[pt++] = c;
        if(pt >= BUFFER_SIZE - 1)
            ClearBuffer();

        if(c =='\n') {
//            if( strncmp( ( const char* )buffer, response, strlen(response) ) == 0 )
            if (strstr(buffer, response) != NULL)
                receiveResponse = true;

//            if( strncmp( ( const char* )buffer, "~~~", 3 ) == 0 )
            if (strstr(buffer, "~~~") != NULL)
                wifiUart.printf("%s", WIFI_ALIVE_RESPONSE);

            if (strstr(buffer, "0|") != NULL)
                rfm.SendMessage(buffer);
/*                
            if (strstr(buffer, "~TIME~") != NULL)
                convert_time();
*/


            /*
                       if( strncmp( ( const char* )_responseBuf, "+IPD,", 5 ) == 0 )
                       {
                           char * pch;
                           pch = strtok (_responseBuf,DELIMITER);
                           uint8_t i = 0 ;
                           while (pch != NULL) {
                               if(i == 1)
                                   bt.printf("%s",pch);
                               pch = strtok (NULL, DELIMITER);
                               i++;
                           }
                       }
            */
            /*
                        if( strncmp( ( const char* )_responseBuf, response, 4 ) == 0 )
                        {
                            OkResponse = true;
            //                bt.printf("OK received !\r\n");
                        }
            */
            /*
                        if( strncmp( ( const char* )_responseBuf, ERROR_MESSAGE, 7 ) == 0 )
                        {
            //                bt.printf("ERROR received !\r\n");
                        }
            */
            ClearBuffer();
        }
    }
};

void ESP8266::SendCommand(char* command, char* answer ,int timeoutMs)
{
    receiveResponse = false;
    response = answer;
    okResponse = false;
    responseTimer.reset();
    wifiUart.printf("%s",command);
    responseTimer.start();
    while(responseTimer.read_ms() < timeoutMs) {
        if(receiveResponse) {
            bt.Send(response);
            responseTimer.stop();
            return;
        }
    }
    responseTimer.stop();
}

void ESP8266::SetIpOfServer(char* command)
{
    memcpy(serverIpAddress, command, sizeof(serverIpAddress));
    setServerIp = true;
};

void ESP8266::SetWiFiConnection(char* command)
{
    memcpy(wifiSettings, command, sizeof(wifiSettings));
    setWifiSettings = true;
};

void ESP8266::SendMessage(char message[])
{
//    pc.printf("%.19s  ", ctime(&epoch_time));
//    pc.printf("%s",actual_time);
//    pc.printf("%s",rtcClock.GetTime());
    pc.printf("%s\r\n",message);
    wifiUart.printf("%s\r\n",message);
};

void ESP8266::CheckSettings()
{
    if(setServerIp && setWifiSettings) {
        SendCommand("+++",(char*)OK_MESSAGE,700);
        SendCommand("AT\r\n",(char*)OK_MESSAGE,200);
        SendCommand("AT+CIPCLOSE\r\n",(char*)OK_MESSAGE,200);
        SendCommand(serverIpAddress,(char*)OK_MESSAGE,200);
        SendCommand(wifiSettings,(char*)OK_MESSAGE,1500);
        SendCommand("AT+RST\r\n","ready",1000);
        setServerIp = false;
        setWifiSettings = false;
    }
    if(setServerIp) {
        SendCommand("+++",(char*)OK_MESSAGE,700);
        SendCommand("AT\r\n",(char*)OK_MESSAGE,300);
        SendCommand("AT+CIPCLOSE\r\n",(char*)OK_MESSAGE,200);
        SendCommand(serverIpAddress,(char*)OK_MESSAGE,200);
        SendCommand("AT+RST\r\n","ready",1000);
        setServerIp = false;
    }
    if(setWifiSettings) {
        SendCommand("+++",(char*)OK_MESSAGE,700);
        SendCommand("AT\r\n",(char*)OK_MESSAGE,200);
        SendCommand("AT+CIPCLOSE\r\n",(char*)OK_MESSAGE,200);
        SendCommand(wifiSettings,(char*)OK_MESSAGE,1500);
        SendCommand("AT+RST\r\n","ready",1000);
        setWifiSettings = false;
    }
};

void ESP8266::ClearBuffer()
{
    memset(buffer, '\0', sizeof(buffer));
    pt = 0;
};

void ESP8266::ConfirmReceivedAck(uint8_t from)
{
    wifiUart.printf("ACK|%c\r\n",from);
};

void ESP8266::Test()
{
    wifiUart.printf("+++\r\n");
    wait(0.1);
    wifiUart.printf("AT\r\n");
    wait(0.2);
    wifiUart.printf("AT\r\n");
    wait(0.2);
    wifiUart.printf("AT\r\n");
    printf("ATTTTTTTTTTT");
    wait(0.2);
};

void ESP8266::convert_time()
{
    pc.printf("%s\r\n", buffer);
    char * pch;
    uint8_t state=0;
    pch = strtok (buffer,DELIMITER);
    while (pch != NULL) {
        switch(state) {
            case 0 :
                wifi.dayOfWeek=atoi(pch);
                wifi.dayOfWeek++;
                state=1;
//                pc.printf("converted day of week : %d  \r\n",dayOfWeek);
                break;
                
            case 1 :
                wifi.date=atoi(pch);
                state=2;
//                pc.printf("converted date : %d  \r\n",date);
                break;

            case 2 :
                wifi.month=atoi(pch);
                state=3;
                break;

            case 3 :
                wifi.year=atoi(pch);
                state=4;
                break;

            case 4 :
                wifi.hour=atoi(pch);
                state=5;
                break;

            case 5 :
                wifi.minute=atoi(pch);
                state=6;
                break;

            case 6 :
                wifi.second=atoi(pch);
                state=7;
                break;

            default:
                state=7;
                break;
        }
        pch = strtok (NULL, DELIMITER);
    }
    actualizeTime = true ;
    
};

void ESP8266::getServerDateTime(int *w, int *d, int *mo, int *y, int *h, int *m, int *s)
{
/*
    *w = wifi.dayOfWeek;
    *d = wifi.date;
    *mo = month;
    *y = year;
    *h = hour;
    *m = minute;
    *s = second;
*/
    *w = wifi.dayOfWeek;
    *d = wifi.date;
    *mo = wifi.month;
    *y = wifi.year;
    *h = wifi.hour;
    *m = wifi.minute;
    *s = wifi.second;

};

bool ESP8266::actualizeActualTime()
{
    if(actualizeTime)
    {
        actualizeTime = false;
        return true;
    }
    return false;
};
