/*
        *Luka Ristić
        *br. indeksa: 2020/0331
*/


//uvoz biblioteka
#include "mbed.h"


//Definisanje direktiva:


//Definisanje globalnih promenljivih:
BusOut display(PA_10, PA_9, PA_8, PB_10, PB_5, PB_4, PB_3, PA_2);
DigitalOut SEL2(PC_7);
DigitalOut SEL1(PB_6);
PwmOut buzzer (PA_11);
InterruptIn sw1 (PC_9);
AnalogIn pot1 (PA_0);
AnalogIn pot2 (PA_1);


//Definisanje pomocnih funkcija:
void isr_sw1(){
    buzzer = 0;
    }

void broj(int x)
 {
     switch(x)
     {
         case 0: display = 0xC0; break;
         case 1: display = 0xF9; break;
         case 2: display = 0xA4; break;
         case 3: display = 0xB0; break;
         case 4: display = 0x99; break;
         case 5: display = 0x92; break;
         case 6: display = 0x82; break;
         case 7: display = 0xF8; break;
         case 8: display = 0x80; break;
         case 9: display = 0x90; break;
         default: display = 0xFF;
     }
 }


//MAIN:
int main()
{
    display = 0xFF;
    sw1.fall(&isr_sw1);
    
//Petlja
    while(1)
    {
        int x;
        buzzer = pot1*0.5f;
        buzzer.period_us(pot2*(-4000.0f)+4000.0f);
        wait_ms(10);
        
        
        //prikaz procenta na 7-sedmentnom displeju
        if(!sw1)
        {
            x = pot1 * 100;
            int jedinice = 0, desetice = 0;
            jedinice = x % 10;
            desetice = x / 10;
            if(desetice==0)
            {
                SEL1 = 1;
                SEL2 = 0;
                broj(jedinice);
            }
            else
            {
                while(!sw1)
                {
                    SEL1 = 1;
                    SEL2 = 0;
                    broj(jedinice);
                    wait_ms(1);
                    SEL1 = 0;
                    SEL2 = 1;
                    broj(desetice);
                    wait_ms(1);
                }
            }
        }
    }
}

/*Na zalost nisam uspeo da ispravim kod tako da mi prikazuje
i cifru jedinice i desetice kada vrednost predje 9% na displeju*/
//Btw kada je sw1 pritisnuto, prikazuju se obe cifre kako treba :/

