#ifndef MOTION_H_
#define MOTION_H_

#include <cstdlib>
#include <mbed.h>
#include "EncoderCounter.h"
#include "Controller.h"
#include "IRSensor.h"


class Motion {
    
    public:
    
        Motion(Controller& controller, EncoderCounter& counterLeft,
                EncoderCounter& counterRight, IRSensor& irSensorL,
                IRSensor& irSensorC, IRSensor& irSensorR, AnalogIn& lineSensor,
                DigitalOut& enableMotorDriver);
        
        virtual ~Motion();
        void    move();
        void    moveFast();
        void    scanMove();
        void    rotateL();
        void    rotateR();
        void    turnL();
        void    turnR();
        void    stop();
        void    rotate180();
        void    control();
        void    runTask(int path[], int task, bool reverse, int junction);
        int     finish();
        void    accel(float targetSpeed);

    private:
    
        static const float  LEFT_MID_VAL;
        static const float  RIGHT_MID_VAL;
        static const float  KP;
        static const float  KD;
        static const int    MOVE_DIST;
        static const float  MOVE_SPEED;
        static const float  SCAN_SPEED;
        static const float  ROTATE_SPEED;
        static const float  ACCEL_CONST;
        
        Controller&         controller;
        EncoderCounter&     counterLeft;
        EncoderCounter&     counterRight;
        IRSensor&           irSensorL;
        IRSensor&           irSensorC;
        IRSensor&           irSensorR;
        AnalogIn&           lineSensor;
        DigitalOut&         enableMotorDriver;
        Timer               t;
        
        float               distanceL;
        float               distanceC;
        float               distanceR;
        int                 countsL;
        int                 countsR;
        int                 countsLOld;
        int                 countsROld;
        float               speedLeft;
        float               speedRight;
        float               errorP;
        float               errorD;
        float               oldErrorP;
        float               totalError;
        int                 waitStop;
        int                 path[];
        int                 task;
        bool                reverse;
        int                 junction;
        bool                acceleration;
        bool                deceleration;
        int                 line;
        float               countsOld;
        float               avgSpeed;
        float               avgCounts;
        float               actSpeed;
        float               targetSpeed;
    };
    
#endif /* MOTION_H_ */