#include "mbed.h"
#include "SDFileSystem.h"
#include "LM19_Driver.h"
#include "PDV_Driver.h"




//Lucy Damon- assignment 6- SD card




Serial pc(USBTX, USBRX);
SDFileSystem sd(p5, p6, p7, p8, "sd");
LM19 t_sensor(p19);
PDV photocell(p20);

Timer print; 

Timer log_timer; 



int main()

{

    int t; 

    pc.printf("Start Log File\n");   //starrting file

    mkdir("/sd/mydir", 0777); 

    FILE *fp = fopen("/sd/mydir/thm_ptc.txt", "w"); 

    

    pc.printf("file_opened \n"); //yay open the file


    if(fp == NULL) {

        error("Could not open file for write\n"); //booo bad file didnt open

    }

    fprintf(fp,"Start Log File\n"); 

    while(1) { //its going to repeat strings

        print.start(); 

        log_timer.start(); 

        if(log_timer.read()<31) { 
            if(print.read()>1) { 

//temp code gained from LM19 driver

                t=log_timer.read_ms(); 
                pc.printf("$TEMP,1,2,%i,%.3f,%.3f;%\r\n",

                          t,

                          t_sensor.volt(),

                          t_sensor.temp());

                fprintf(fp, "Time = %i, temp=%f, volts=%f\r\n", 
                        t, 

                        t_sensor.volt(), 

                        t_sensor.temp()); 

//photocell code from PDV driver 

                pc.printf("$PDV,1,2,%i,%.3f,%.3f;%\r\n",

                          t,

                          photocell.volt(),

                          photocell.resistance());

                fprintf(fp, "Time = %i, volts=%f, resistance=%f\r\n", 

                        t, 

                        photocell.volt(), 
                        photocell.resistance()); 

                print.reset(); //reset strings
            }

//stuff to print when strings are done/ reached capacity

        } else {
            fprintf(fp, "Log = Full");

            fclose(fp); 

            pc.printf("Log = Successful \n");

            wait(1);

        }

    }

}