#include "mbed.h"
#include "direction.h"
#include "list.h"
#include "draw.h"
#include "game.h"

DigitalOut myled(LED1);
DigitalOut myled2(LED2);
DigitalIn  pb(p17);

int main() {
    pb.mode(PullUp);
    myled2 = 1;
    SDirection direction, newDirection;
    List snake = {NULL,NULL};
    Apple apple;
    int points;
    int tempRow, tempCol;
    int draw_yes = 0;
    int draw_y2 = 0;
    int spx = 0;
    int spy = 0;
    int i;
    State game = splash;
    drawSetup();

    while(1) {
    wait(0.016666667);
    myled = !myled;
        switch(game) {
            case splash:
                draw_y2++;
                if(draw_y2 == 19) {
                    drawBlank(spy,spx);
                    spx = rand() % COL;
                    spy = rand() % ROW;
                    drawApple(spy,spx);
                    draw_y2 = 0;
                }    
                if((direction = getDirection(none)) != none) game = start;
                break;
            case start:               
                if((direction = getDirection(none)) != none) {
                    deleteList(&snake);
                    clearscr();
                    for(i = -1; i < COL + 2; i++){
                        drawPixel(-1,i,0xFFFFFF);
                    }
                    for(i = 0; i < ROW + 2; i++) {                      
                        drawPixel(i,COL+1,0xFFFFFF);
                    }
                    for(i = COL + 1; i > -2; i--){
                        drawPixel(ROW+1,i,0xFFFFFF);
                    }
                    for(i = ROW + 1; i > -2; i--) {                      
                        drawPixel(i,-1,0xFFFFFF);
                    }
                    addToHead(&snake, 5, 5);
                    addToHead(&snake, 5, 6);
                    addToHead(&snake, 5, 7);
                    apple.row = rand() % (ROW - 1) + 1;
                    apple.col = rand() % (COL - 3) + 3;
                    points = 0;
                    game = run;
                }
                break;
            case run:
                // control
                newDirection = getDirection(newDirection);
                draw_yes++;
                if(draw_yes == 14) game = draw;
                break;
           
           case draw:     
                //model
                draw_yes = 0;
                game = run;
                //left
                if(newDirection == left && direction != right || newDirection == none && direction == left || direction == left && newDirection == right) {
                    direction = left;
                    //pc.printf("left\n\r");
                    addToHead(&snake, snake.head->row, snake.head->col - 1);
                    if (snake.head->row == apple.row && snake.head->col == apple.col) {
                        tempRow = -1;
                        tempCol = -1;
                        score(&apple, &points);
                    } else {
                        tempRow = snake.tail->row;
                        tempCol = snake.tail->col;
                        removeFromTail(&snake);
                    }
                //right    
                } else if (newDirection == right && direction != left || newDirection == none && direction == right || direction == right && newDirection == left) {
                    addToHead(&snake, snake.head->row, snake.head->col + 1);
                    direction = right;
                    //pc.printf("right\n\r");                    
                    if (snake.head->row == apple.row && snake.head->col == apple.col) {
                        tempRow = -1;
                        tempCol = -1;
                        score(&apple, &points);
                    } else {
                        tempRow = snake.tail->row;
                        tempCol = snake.tail->col;
                        removeFromTail(&snake);
                    }
                //up    
                } else if (newDirection == up && direction != down || newDirection == none && direction == up|| direction == up && newDirection == down) {
                    addToHead(&snake, snake.head->row - 1, snake.head->col);
                    direction = up;
                    //pc.printf("up\n\r");                    
                    if (snake.head->row == apple.row && snake.head->col == apple.col) {
                        tempRow = -1;
                        tempCol = -1;
                        score(&apple, &points);
                    } else {
                        tempRow = snake.tail->row;
                        tempCol = snake.tail->col;
                        removeFromTail(&snake);
                    }
                //down    
                } else if (newDirection == down && direction != up || newDirection == none && direction == down|| direction == down&& newDirection == up) {
                    addToHead(&snake, snake.head->row + 1, snake.head->col);
                    direction = down;
                    //pc.printf("down\n\r");
                    if (snake.head->row == apple.row && snake.head->col == apple.col) {
                        tempRow = -1;
                        tempCol = -1;
                        score(&apple, &points);
                    } else {
                        tempRow = snake.tail->row;
                        tempCol = snake.tail->col;
                        removeFromTail(&snake);
                    }
                }
                
               if(!checkGameOver(&snake)){
                    game = end;
                    break;
                }
                
                //view
                if(tempRow >= 0) {
                    drawBlank(tempRow, tempCol);
                }
                drawApple(apple.row, apple.col);
                drawSnake(snake.head->row, snake.head->col);
                drawScore(points);
                break;
            case end:            
                if(!pb) { 
                game = splash;
                clearscr();
                }
                break;
        }                
    }
}
