#include "mbed.h"
#include "list.h"


void addToHead(List* list, int row, int col)
{

    Lnode* head = (Lnode*) malloc(sizeof(Lnode));
    head->row = row;
    head->col = col;
    head->next = list->head;
    head->prev = NULL;
    if(list->head) {
        list->head->prev = head;
        list->head = head;
    } else {
        list->head = head;
        list->tail = head;
    }
}

void removeFromTail(List* list)
{
    if(list->tail) {
        list->tail = list->tail->prev;
        free(list->tail->next);
        if(list->tail) {
            list->tail->next = NULL;
        } else {
            list->head = NULL;
        }
    }
}

void deleteList(List* list)
{
    Lnode* phere = list->head;
    Lnode* temp;
    while(phere != NULL) {
        temp = phere->next;
        free(phere);
        phere = temp;
    }
    list->head = NULL;
    list->tail = NULL;
}