#include "mbed.h"
#include "TFT_4DGL.h"
#include "draw.h"


TFT_4DGL ecran(p28,p27,p23); // serial tx, serial rx, reset pin;

void drawSetup() {
    ecran.baudrate(115200);
    ecran.cls();
// added - Set Display to 640 by 480 mode
    ecran.display_control(0x0c, 0x01);
//
    ecran.background_color(DGREY);
}

void clearscr() {
    ecran.cls();
}

void drawPixel(int row, int col, int color) {
    ecran.rectangle(col*15+135, row*15+80, col*15+149, row*15+94, color);
}

void drawSnake(int row, int col) {
    drawPixel(row, col, 0x00FF00);
}

void drawApple(int row, int col) {
    //drawPixel(row, col, 0xFF0000);
    ecran.rectangle(col*15 + 138, row*15 + 85, col*15 + 145, row*15 + 91, RED);
    ecran.rectangle(col*15 + 137, row*15 + 87, col*15 + 146, row*15 + 89, RED);
    ecran.rectangle(col*15 + 139, row*15 + 92, col*15 + 144, row*15 + 92, RED);
    ecran.rectangle(col*15 + 137, row*15 + 84, col*15 + 143, row*15 + 84, GREEN);
    ecran.rectangle(col*15 + 141, row*15 + 83, col*15 + 146, row*15 + 83, GREEN);
}

void drawBlank(int row, int col) {
    drawPixel(row, col, DGREY);
}

void drawScore(int score) {
        char scr[15];
        sprintf(scr, "Score: %d", score);  
        ecran.text_string(scr, 285, 302, FONT_8X8, WHITE);        
}