#include "mbed.h"
#include "CAN.h"
#include "can_helper.h"
#include "stdio.h"


InterruptIn ign(D8);
InterruptIn botao(PC_13); // definição do botão de usuário

Serial pc(USBTX, USBRX);
CAN can1(PA_11, PA_12);

PwmOut inj1(D9);
PwmOut inj2(D7);
PwmOut inj3(PA_14);
PwmOut inj4(D14);


// AnalogIn pot(PB_1);

int tempo = 6000;
int m;
int valor_pot;
unsigned int estado;
void toggle(void);
int ig = 0;
float leitura;
float leitura_count;
float RPM;
float RPM_medio;
float ta=0;

int fase=0;

Timer debounce;
Timer debounce_real;

int main() {
  debounce.start();
  ign.rise(&toggle);
  pc.baud(9600); 
  CANMessage msg;

while(1) {

if(can1.read(msg)) {
                 if (msg.id==6){
                    if (msg.data=="0x09"){
                       ta= 3*10^-8*RPM^2-9*10^-5*RPM+1.36;
                       }
                    if (msg.data=="0x10"){
                       ta= 2*10^-8*RPM^2-8*10^-5*RPM+1.46;
                       }
                    if (msg.data=="0x08"){
                       ta= 7*10^-54*RPM +1.43;
                       }
                    //if (msg.data==0.8){
//                       //av= 2*10^-5*RPM +1.57;
//                       }
//                    if (msg.data==1){
//                       //av= 5*10^-8*RPM^2-7*10^-5*RPM+2.06;
//                       }

printf("\n Message id :%d", msg.id);

printf("\n Message received: %s", msg.data);



} }// definição da taxa de transferencia de dados do conector USB
  // 3 braços começam desacoplados
}}

void toggle() {
    leitura = debounce.read();
    ig++;
    //printf("\n\rtempo:%f e rpm:%f",leitura, RPM);
    
    if (ig==31){
        ig++;
        
        
        if (fase==0){
        inj1.period(leitura*4);      // 4 second period
        inj1.write(0.050f/4);
        }
        if (fase==1){
        inj2.period(leitura*4);      // 4 second period
        inj2.write(0.050f/4);
        } 
        if (fase==2){
        inj3.period(leitura*4);      // 4 second period
        inj3.write(0.050f/4);
        }
        if (fase==3){
        inj4.period(leitura*4);      // 4 second period
        inj4.write(0.050f/4);
        } 
        
        wait_us(ta);
       
        ig=0; 
           
        fase++;  
        if (fase>3){
        fase=0;
        } 
        debounce.reset();
      
    }

    

}