#include "mbed.h"
#include "CAN.h"
#include "can_helper.h"
#include "stdio.h"

InterruptIn ign(D8);
InterruptIn botao(PC_13); // definição do botão de usuário

Serial pc(USBTX, USBRX);
CAN can1(PA_11, PA_12);

PwmOut rot(D9);
PwmOut ign1(D7);
PwmOut ign2(D14);


// AnalogIn pot(PB_1);
//---------Dados em hexadecimal de cada mensagem-------
static char info = 0x55;

void toggle(void);

int ig = 0;
float leitura;
float leitura_count;
int RPM;
float RPM_medio;
float ta;
int av=20;
int fase=0;
int c;
int co;
Timer debounce;
Timer timer;
CANMessage msg;




int main() {
  debounce.start();
  timer.start();
  ign.rise(&toggle);
  pc.baud(115200); 
    while(1) {
        if (timer.read()>5) {
            
            //outputFloat(RPM);
          
            char rpm[4];
            sprintf(rpm, "%d", RPM);
            can1.write(CANMessage(20, rpm , 8,CANData,CANStandard ));
            if(can1.read(msg)) {
                if (msg.id==6){
                    if (msg.data=="0x09"){
                       av= 4*10^-3*RPM +6;
                       }
                    if (msg.data=="0x10"){
                       av= 6*10^-3*RPM +4;
                       }
                    if (msg.data=="0x11"){
                         av= -9*10^-7*RPM*RPM+0.0091*RPM+1.6;
                       }
                    //if (msg.data==""){
//                       av= -8*57^-7*RPM^2+0.00954*RPM+1.6;
//                       }
//                    if (msg.data==""){
//                       av= 6*10^-3*RPM +5.4;
//                       }
                   
                   // av=float(msg.data)
                    }
                

            printf("\n\r Message id :%d", msg.id);
            
            printf("\n\r Message received: %s", msg.data);
            }            
            timer.reset();
        }
    }
}

void toggle() {  
    ig++;   
    if (ig==31){
        ig++;
        leitura = debounce.read();
        if (fase==0){
        ign1.period(leitura*2);      // 4 second period
        ign1.write(0.050f/2);
        }
        if (fase==1){
        ign2.period(leitura*2);      // 4 second period
        ign2.write(0.050f/2);
        } 
        ta= av*1000/(RPM*6);
        wait_us((leitura*1000-ta)*1000);
        rot.period(leitura);      // 4 second period
        rot.write(0.050f);   
        RPM = 60/(leitura);
        fase++;
        if (fase>=2){
        fase=0;
        } 
        ig=0;
        debounce.reset();
               
        
    } 
       
}

