#include "mbed.h"
#include <math.h>

DigitalOut IN_1(D5);
DigitalOut IN_2(D4);
DigitalOut EN_12(D2);
DigitalOut IN_3(A0);
DigitalOut IN_4(A1);
DigitalOut EN_34(A4);
InterruptIn ign(D8);
InterruptIn botao(PC_13); // definição do botão de usuário
Serial pc(USBTX, USBRX);
PwmOut saida1(D9);
PwmOut saida2(D14);
PwmOut saida3(PA_14);
PwmOut saida4(D7);

int tempo = 6000;
int m;
int valor_pot;
unsigned int estado;
void toggle(void);
int ig = 0;
int fase = 0;
float leitura;
float RPM;
float RPM_medio;
float ta;
float av;

Timer debounce;
Timer debounce_real;

void bot_pressed(void);

int main() {
  debounce.start();
  debounce_real.start();
  pc.baud(9600); // definição da taxa de transferencia de dados do conector USB
  // 3 braços começam desacoplados
  IN_1 = 0;
  IN_2 = 0;
  IN_3 = 0;
  IN_4 = 0;
  EN_12 = 0;
  EN_34 = 0;
  estado = -3;

  botao.fall(&bot_pressed);

  while (1) {
    wait_us(1);
    if (estado == -3) {
      pc.printf("\n\rescolha o modo de operacao do carro!");
      estado = -2;
    }
    if (estado == -2) {
      // pc.printf("%d",estado);
      char s = pc.getc();
      // pc.printf("digite o número desejado");
      // Se o comando for 1 = temos o estado ligado (enable)
      if (s == '1' && estado == -2) {

        pc.printf("estado 1\r\n");
        estado = 1;
        wait_us(1000);
      }
      // Se o comando for 6 = temos o estado desligado (disable)
      if (s == '2' && estado == -2) {

        pc.printf("estado 2\r\n");
        estado = 3;

        wait_us(1000);
      }
      // Se o comando for 2 = temos a alteração entre o perfil trapezoidal e o
      // perfil "manual"
      if (s == '3' && estado == -2) {
        s = '\0';
        estado = 5;
        pc.printf("estado 3\r\n");
        wait_us(1000);
      }
      // wait_us(1000);
    }
    if (estado == -1) {
      pc.printf("\n\rcarro desligado! RPM = 0. Deslocamento linear: 0 mm");

      for (int i = 0; i < 60; ++i) {
        // sequencia de acionamento de cada braço com diferentes polaridades
        // seguidas de desacoplamento, fazendo uma sequencia que permite que o
        // motor funcione atráves de 6 passos step1
        pc.printf("\n\rvoltando");

        EN_12 = 1;
        EN_34 = 0;
        IN_1 = 1;
        IN_2 = 0;

        wait_us(tempo);

        IN_1 = 0;
        IN_2 = 1;

        wait_us(tempo);
        EN_12 = 0;
        EN_34 = 1;
        IN_3 = 1;
        IN_4 = 0;

        wait_us(tempo);
        IN_3 = 0;
        IN_4 = 1;
        wait_us(tempo);
      }
      pc.printf("\n\rvoltou");

      IN_1 = 0;
      IN_2 = 0;
      IN_3 = 0;
      IN_4 = 0;
      EN_12 = 0;
      EN_34 = 0;
      estado = 0;
    }
    if (estado == 1) { //
      pc.printf("\n\rtemperatura: GELADO. RPM = 1200. Pressão: 0.6 bar. "
                "Deslocamento linear: 10 mm");

      for (int i = 0; i < 60; ++i) {
        // sequencia de acionamento de cada braço com diferentes polaridades
        // seguidas de desacoplamento, fazendo uma sequencia que permite que o
        // motor funcione atráves de 6 passos step1
        pc.printf("\n\rvoltando");

        EN_12 = 1;
        EN_34 = 0;
        IN_1 = 1;
        IN_2 = 0;

        wait_us(tempo);

        IN_1 = 0;
        IN_2 = 1;

        wait_us(tempo);
        EN_12 = 0;
        EN_34 = 1;
        IN_3 = 1;
        IN_4 = 0;

        wait_us(tempo);
        IN_3 = 0;
        IN_4 = 1;
        wait_us(tempo);
      }
      pc.printf("\n\rvoltou");

      IN_1 = 0;
      IN_2 = 0;
      IN_3 = 0;
      IN_4 = 0;
      EN_12 = 0;
      EN_34 = 0;
      estado = 0;
    ign.rise(&toggle);
            av = RPM*leitura+4;
    

    }

    if (estado == 3) { //
      pc.printf("\n\rtemperatura: QUENTE. RPM = 1000. Pressão: 0.2 bar. Deslocamento linear: 0 mm");

      for (int i = 0; i < 60; ++i) {//dentro
        // sequencia de acionamento de cada braço com diferentes polaridades
        // seguidas de desacoplamento, fazendo uma sequencia que permite que o
        // motor funcione atráves de 6 passos step1
        pc.printf("\n\rvoltando");

        EN_12 = 1;
        EN_34 = 0;
        IN_1 = 1;
        IN_2 = 0;

        wait_us(tempo);

        IN_1 = 0;
        IN_2 = 1;

        wait_us(tempo);
        EN_12 = 0;
        EN_34 = 1;
        IN_3 = 1;
        IN_4 = 0;

        wait_us(tempo);
        IN_3 = 0;
        IN_4 = 1;
        wait_us(tempo);
      }
      pc.printf("\n\rvoltou");

      for (int i = 0; i < 32; ++i) {//fora
        pc.printf("\n\rfora");

        // sequencia de acionamento de cada braço com diferentes polaridades
        // seguidas de desacoplamento, fazendo uma sequencia que permite que o
        // motor funcione atráves de 6 passos step1
        EN_12 = 0;
        EN_34 = 1;
        IN_3 = 0;
        IN_4 = 1;

        wait_us(tempo);

        IN_3 = 1;
        IN_4 = 0;

        wait_us(tempo);
        EN_34 = 0;
        EN_12 = 1;

        IN_1 = 0;
        IN_2 = 1;

        wait_us(tempo);

        IN_1 = 1;
        IN_2 = 0;

        wait_us(tempo);
      }
      IN_1 = 0;
      IN_2 = 0;
      IN_3 = 0;
      IN_4 = 0;
      EN_12 = 0;
      EN_34 = 0;
      estado = 0;
      ign.rise(&toggle);
      av = -3*pow(10,-6)*RPM*RPM+1.5*pow(10,-2)*RPM-2;

    }

  if (estado == 5) {
    pc.printf("\n\rtemperatura: LIGARAM O AR. RPM = 1100. Pressão: 0.4 bar. "
              "Deslocamento linear: 4 mm");
    for (int i = 0; i < 60; ++i) {//dentro total
        pc.printf("\n\rvoltando");

        EN_12 = 1;
        EN_34 = 0;
        IN_1 = 1;
        IN_2 = 0;

        wait_us(tempo);

        IN_1 = 0;
        IN_2 = 1;

        wait_us(tempo);
        EN_12 = 0;
        EN_34 = 1;
        IN_3 = 1;
        IN_4 = 0;

        wait_us(tempo);
        IN_3 = 0;
        IN_4 = 1;
        wait_us(tempo);
      }
    for (int i = 0; i < 24; ++i) {
      pc.printf("\n\rfora");
      // sequencia de acionamento de cada braço com diferentes polaridades
      // seguidas de desacoplamento, fazendo uma sequencia que permite que o
      // motor funcione atráves de 6 passos step1
      EN_12 = 0;
      EN_34 = 1;
      IN_3 = 0;
      IN_4 = 1;

      wait_us(tempo);

      IN_3 = 1;
      IN_4 = 0;

      wait_us(tempo);
      EN_34 = 0;
      EN_12 = 1;

      IN_1 = 0;
      IN_2 = 1;

      wait_us(tempo);

      IN_1 = 1;
      IN_2 = 0;

      wait_us(tempo);
    }
    pc.printf("\n\racabou");
    IN_1 = 0;
    IN_2 = 0;
    IN_3 = 0;
    IN_4 = 0;
    EN_12 = 0;
    EN_34 = 0;
    estado = 0;
    ign.rise(&toggle);
    av = -2*pow(10,-6)*RPM*RPM+pow(10,-2)*RPM+2;
  }
}
}

void toggle() {
    leitura = debounce.read();
    if (ig==12){
        
        RPM = 60/leitura;
        ta= av*1000/(RPM*6);
        wait_us((leitura*1000-ta)*1000);
        if (fase==0){
        saida1.period(leitura*4);      
        saida1.write(0.050f/4);
        }
        if (fase==1){
        saida3.period(leitura*4);      
        saida3.write(0.050f/4);
        }
        if (fase==2){
        saida4.period(leitura*4);     
        saida4.write(0.050f/4);
        }
        if (fase==3){
        saida2.period(leitura*4);     
        saida2.write(0.050f/4);
        }
        printf("\n\rtempo:%f e rpm:%f",leitura, RPM);
        ig=0; 
        debounce.reset();   
        fase++;    
           
    }
    else{
        ig++;
        
        }
    debounce.reset();
    if (fase>3){
        fase=0;
        } 

}
void bot_pressed() {
  if (debounce_real.read_ms() > 250) {
    estado = -3;
    debounce_real.reset();
    ign.rise(NULL);
  }
}