#include "mbed.h"

//-------Declara uso da serial---------------------
Serial pc(USBTX, USBRX); // tx, rx

//----------Pinos de entrada analogica (ADC)------
AnalogIn AXIS_X(A3);
AnalogIn AXIS_Y(A5);

//--------Declara uso da CAN----------------------
CAN can1(PB_8, PB_9);

//--------Declara uso do LED nativo da placa------
DigitalOut LED(PA_5);

//-----Declara uso do botao nativo da placa--------
DigitalIn SW(PC_13);

//---------Dados em hexadecimal de cada mensagem-------
static char info = 0x55;
static char left = 0x01;
static char right = 0x02;
static char up = 0x03;
static char down = 0x04;
static char stop = 0x05;

DigitalOut IN1A(D5); // Sinal IN1
DigitalOut IN2A(D4); // Sinal IN2
DigitalOut EN_A(D2); // Sinal ENABLE
DigitalOut IN1B(A0); // Sinal IN1
DigitalOut IN2B(A1); // Sinal IN2
DigitalOut EN_B(A4); // Sinal ENABLE

int main() {

  //-----atribuição dos dados as mensagens----------
  CANMessage msg(5, &info, 8, CANData, CANStandard);
  CANMessage msg_up(5, &up, 8, CANData, CANStandard);
  CANMessage msg_down(5, &down, 8, CANData, CANStandard);
  CANMessage msg_left(5, &left, 8, CANData, CANStandard);
  CANMessage msg_right(5, &right, 8, CANData, CANStandard);
  CANMessage msg_stop(5, &stop, 8, CANData, CANStandard);

  //---boas vindas------------
  pc.printf("Ola!!!\n");

  float VAL_X = 0.0f, VAL_Y = 0.0f;

  while (1) {
    if (can1.read(msg)) {

      if (msg.data[0] == up) {
        // move_up();
        pc.printf("Cima recebida: %x\n", msg_up.data[0]);
        EN_A = 1;
        EN_B = 0;
        IN1A = 0;
        IN2A = 1;
        IN1B = 0;
        IN2B = 0;
      }

      //------Se a mensagem for do tipo DOWN, então move para baixo----
      if (msg.data[0] == down) {
        // move_down();
        pc.printf("Baixo recebida: %x\n", msg_down.data[0]);
        EN_A = 1;
        EN_B = 0;
        IN1A = 1;
        IN2A = 0;
        IN1B = 0;
        IN2B = 0;
      }

      //------Se a mensagem for do tipo RIGHT, então move para direita----
      if (msg.data[0] == right) {
        // move_right();
        pc.printf("Direita recebida: %x\n", msg_right.data[0]);
        EN_A = 0;
        EN_B = 1;
        IN1A = 0;
        IN2A = 0;
        IN1B = 0;
        IN2B = 1;
      }

      //------Se a mensagem for do tipo LEFT, então move para esquerda----
      if (msg.data[0] == left) {
        // move_left();
        pc.printf("Esquerda recebida: %x\n", msg_left.data[0]);
        EN_A = 0;
        EN_B = 1;
        IN1A = 0;
        IN2A = 0;
        IN1B = 1;
        IN2B = 0;
      }

      //------Se a mensagem for do tipo STOP, então para os motores------
      if (msg.data[0] == stop) {
        // move_stop();
        pc.printf("Parada recebida: %x\n", msg_stop.data[0]);
        EN_A = 0;
        EN_B = 0;
        IN1A = 0;
        IN2A = 0;
        IN1B = 0;
        IN2B = 0;
      }

      msg.data[0] = 0x00; // limpa a variavel
    }
    wait_us(20000); // controla o envio/recebimento de mensagens
  }
}