#include "mbed.h"

//-------Declara uso da serial---------------------
Serial pc(USBTX, USBRX); // tx, rx

//----------Pinos de entrada analogica (ADC)------
AnalogIn   AXIS_X(A3);
AnalogIn   AXIS_Y(A5);

//--------Declara uso da CAN----------------------
CAN can1(PB_8, PB_9);

//--------Declara uso do LED nativo da placa------
DigitalOut LED(PA_5);

//-----Declara uso do botao nativo da placa--------
DigitalIn SW(PC_13);

//---------Dados em hexadecimal de cada mensagem-------
static char info =  0x55;
static char left =  0x01;
static char right = 0x02;
static char up =    0x03;
static char down =  0x04;
static char stop =  0x05;

int main() 
{    
    //-----atribuição dos dados as mensagens----------
    CANMessage msg(5, &info, 8, CANData, CANStandard);
    CANMessage msg_up(5, &up, 8, CANData, CANStandard);
    CANMessage msg_down(5, &down, 8, CANData, CANStandard);
    CANMessage msg_left(5, &left, 8, CANData, CANStandard);
    CANMessage msg_right(5, &right, 8, CANData, CANStandard);
    CANMessage msg_stop(5, &stop, 8, CANData, CANStandard);
    
    //---boas vindas------------
    pc.printf("Ola!!!\n");
   
    float VAL_X = 0.0f, VAL_Y = 0.0f;
    
    while(1) 
    {
        //------Leitura do joystick nos eixos X e Y --------------
        VAL_X = AXIS_X.read();
        VAL_Y = AXIS_Y.read();
               
        //----Envia mensagem para +Y -----
        if(VAL_X > 0.7f)
        {
            if(can1.write(msg_right))
            {
                pc.printf("Direita enviada\n");            
            }
                
            else
            {
                pc.printf("Direita NAO enviada\n");                   
            }       
        }
        
        //----Envia mensagem para -Y -----
        if(VAL_X < 0.3f)
        {
            //printf("\n\rLEFT");
            if(can1.write(msg_left))
            {
                pc.printf("Esquerda enviada\n");            
            }
                
            else
            {
                pc.printf("Esquerda NAO enviada\n");                   
            }       
        }
        
        //----Envia mensagem para +X -----
        if(VAL_Y > 0.7f)
        {
            //printf("\n\rUP");
            if(can1.write(msg_up))
                {
                    pc.printf("Cima enviada\n");            
                }
                
                else
                {
                    pc.printf("Cima NAO enviada\n");                   
                }       
        }
        
        //----Envia mensagem para -X -----
        if(VAL_Y < 0.3f)
        {      
            //printf("\n\rDown");
            if(can1.write(msg_down))
            {
                pc.printf("Baixo enviada\n");            
            }
                
            else
            {
                pc.printf("Baixo NAO enviada\n");                   
            }       
        } 
        
        //----Se o joystick estiver em repouso, envia mensagem para parar os motores dos eixos--------
        if(((VAL_Y < 0.65f) && (VAL_Y > 0.45f)) && ((VAL_X < 0.65f) && (VAL_X > 0.45f)))
        {
            //printf("\n\rStop");
            if(can1.write(msg_stop))
            {
                pc.printf("Parada enviada\n");            
            }
                
            else
            {
                pc.printf("Parada NAO enviada\n");                   
            } 
        }     
        msg.data[0] = 0x00;//limpa a variavel
                
        wait_us(200000);//controla o envio/recebimento de mensagens
    }
}