#ifndef MBED_MULTITECHDOT_DOT_DEFS_H
#define MBED_MULTITECHDOT_DOT_DEFS_H

#include "mDot.h"
#include "MTSLog.h"

struct dot_config {
    /**
     * Join Mode
     */
     mDot::JoinMode join_mode;

    /**
     * DevAddr, 4 bytes, for MANUAL (ABP) join mode.
     */
    uint8_t network_address[4];

    /**
     * NwkSKey, 16 bytes, for MANUAL (ABP) join mode.
     */
    uint8_t network_session_key[16];

    /**
     *  AppSKey, 16 bytes, for MANUAL (ABP) join mode.
     */
    uint8_t data_session_key[16];

    /**
     *  AppEUI or Network ID, 16 bytes, for OTA join mode.
     */
    uint8_t network_id[16];

    /**
     *  AppKey or Network Key, 16 bytes, for OTA join mode.
     */
    uint8_t network_key[16];

    uint8_t join_delay;

    uint8_t frequency_sub_band;

    bool public_network;

    /**
     * Acknowledgements: 0 to disable acks, otherwise 1 - 8
     */
    uint8_t ack;

    mDot::DataRates data_rate;

    /**
     * Enable Adaptive Data Rate
     */
    bool adr;

    /**
     * Sleep time in seconds
     */
    uint32_t sleep_time_s;

    /**
     * Should sleep deeply
     */
    bool should_deep_sleep;

    /**
     * Log level mts::MTSLog
     */
    mts::MTSLog::logLevel log_level;

    /**
     * Disable duty cycle only for debugging radio purposes. Let it set on false for production.
     */
    bool disable_duty_cycle;
};

#endif
