#ifndef MBED_BASEDOT_H
#define MBED_BASEDOT_H

#include "mbed.h"
#include "mDot.h"
#include "MTSLog.h"
#include "MTSText.h"
#include "dot_defs.h"
#include "xdot_low_power.h"

/**
 * Base Dot class from dot_utils available in Dot Examples.
 * https://os.mbed.com/teams/MultiTech/code/Dot-Examples/
 *
 * Refactor by:
 * 1. copying all the `dot_utils.h` function signatures as protected methods in `BaseDot.h`
 * 2. copying all the `dot_utils.cpp` function definitions in `BaseDot.cpp`
 * 3. adding `BaseDot::` prefix to each function definition from `BaseDot.cpp`
 *
 * Last updated from revision 2f5ae37e6c47
 */

class BaseDot : public mDot {
public:
    void display_config();

    void update_ota_config_name_phrase(
            std::string network_name, std::string network_passphrase,
            uint8_t frequency_sub_band, bool public_network, uint8_t ack
    );

    void update_ota_config_id_key(
            uint8_t *network_id, uint8_t *network_key,
            uint8_t frequency_sub_band, bool public_network, uint8_t ack
    );

    void update_manual_config(
            uint8_t *network_address, uint8_t *network_session_key, uint8_t *data_session_key,
            uint8_t frequency_sub_band, bool public_network, uint8_t ack
    );

    void update_peer_to_peer_config(
            uint8_t *network_address, uint8_t *network_session_key, uint8_t *data_session_key,
            uint32_t tx_frequency, uint8_t tx_datarate, uint8_t tx_power
    );

    void update_network_link_check_config(uint8_t link_check_count, uint8_t link_check_threshold);

    void join_network();

    void sleep_wake_rtc_only(bool deepsleep);

    void sleep_wake_interrupt_only(bool deepsleep);

    void sleep_wake_rtc_or_interrupt(bool deepsleep);

    void sleep_save_io();

    void sleep_configure_io();

    void sleep_restore_io();

    int32_t send_data(std::vector<uint8_t> data);
};


#endif
