/*
  AirQuality library v1.0
  2010 Copyright (c) Seeed Technology Inc.  All right reserved.

  Original Author: Bruce.Qin

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef __AIRQUALITY_H__
#define __AIRQUALITY_H__

#include "mbed.h"
#include "mbed_debug.h"

#ifndef DEBUG_AIR_QUALITY
#define DEBUG_AIR_QUALITY 0
#endif

enum air_quality_values {
    UNKNOWN = -1,
    VERY_HIGH_POLLUTION = 0,
    HIGH_POLLUTION = 1,
    LOW_POLLUTION = 2,
    NO_POLLUTION = 3
};

class AirQuality {
public:
    uint16_t standard_vol;
    uint16_t init_voltage;
    uint16_t first_vol;
    uint16_t last_vol;

    AirQuality();

    void set_calc_avg_volt_period(uint16_t seconds);
    void set_sampling_period(uint16_t seconds);
    void set_heating_delay(uint16_t seconds);

    void init(PinName pin);

    air_quality_values slope(void);

protected:
    uint16_t _heating_delay_s;
    uint16_t _sampling_period_s;
    uint16_t _sum_vol;
    uint16_t _calc_avg_volt_period_s;
    bool _was_sampled;
    bool _has_error;

private:
    uint8_t _s;
    PinName _pin;

    void calcAvgVoltageFor(uint16_t minutes);
};

#endif
