#include "DS18B20.h"

DS18B20::DS18B20(PinName oneBus):oneBus_(oneBus){

}

/*
    send message to every sensor on the bus to take a reading
*/

void DS18B20::broadcastConvert() {
    //broadcast that temp conversions should begin, all at once so saves time
    oneBus_.init();
    oneBus_.writeByte(0xCC);
    oneBus_.writeByte(0x44);

    while (1) {
        if (oneBus_.readBit())
            break;
    }
}

/*
    retrieve temperatures from sensors
*/

float DS18B20::getTemperature(unsigned char* address) {
    //get temperature from the device with address address
    float temperature;
    int scratchPad[9] = {0,0,0,0,0,0,0,0,0};

    oneBus_.init();
    oneBus_.writeByte(0x55);
    for (int i = 0; i < 8; i++)
        oneBus_.writeByte(address[i]);
    oneBus_.writeByte(0xBE);

    for (int i = 0; i < 2; i++) {
        scratchPad[i] = oneBus_.readByte();
    }
    oneBus_.init();
    temperature = ((scratchPad[1] * 256) + scratchPad[0])*0.0625;

    return temperature;
}

/*
    retrieve address of sensor and print to terminal
*/

void DS18B20::printSingleAddress() {
    oneBus_.init();
    //attach one sensor to port 25 and this will print out it's address
    unsigned char address[8]= {0,0,0,0,0,0,0,0};

    oneBus_.writeByte(0x33);

    for (int i = 0; i<8; i++)
        address[i] = oneBus_.readByte();
    for (int i = 0; i<8; i++)
        printf("0x%x,",address[i]);
    
    //check crc
    unsigned char crc = oneBus_.CRC(address, 7);
    printf("crc = %x \r\n",crc);
}