#ifndef DS1820_H_
#define DS1820_H_

#include <OneWire.h>
#include "mbed_debug.h"

#define DEBUG 0

class DS1820 {
    OneWire oneWire;
    bool present;
    bool model_s;
    uint8_t data[12];
    uint8_t addr[8];

public:

    DS1820(PinName pin);

    DS1820(char model, PinName pin);

    bool begin(void);

    bool isPresent();

    void setResolution(uint8_t res);

    virtual void startConversion(void);

    virtual uint8_t readRaw(uint16_t &temp);

    uint8_t read(float &temp);

protected:
    float toFloat(uint16_t word);
};

#endif /* DS1820_H_ */
