#include "mbed.h"
#include "tsi_sensor.h"
#include "MMA8451Q.h"

//General
#define TRUE                1
#define FALSE               0
#define ON                  0
#define OFF                 1

//Maq estados
#define DESHABILITADO       0
#define REPOSO              1
#define CAPTURANDO_ADC      2
#define DATOS_FULL          3

//Set points
#define SET_ACELEROMETRO    707 //(Sen45)*1000
#define SET_TOUCH           .7

//Perifericos
#define ELEC0               9
#define ELEC1               10
#define MMA8451_I2C_ADDRESS (0x1d<<1)

// Maquina de estados de recepcion de Trama
#define     ENCABEZADO                      0
#define     ACCION                          1
#define     COMANDO                         2
#define     COMA                            3
#define     TIEMPO_MUESTREO                 4
#define     MODO_DE_MUESTREO                5
#define     ASTERISCO                       6
#define     CHEQUEO                         7
#define     FIN_DE_TRAMA                    8

// Resultados posibles de la tla recepcion
#define     CONFIGURACION_RECIBIDA          1
#define     SOLICITUD_DE_CONFIGURACION      2
#define     SOLICITUD_DE_MUESTRAS           3

// Tamaño del buffer de recepcion
#define     MAX_BUFFER                      100

//Maq de estados
void MaquinaDeEstados ( void );

//Perifericos
void blink_lg ( void );
void blink_lr ( void );
void interrupcion_timer();
void interrupcion_UART();

// Comunicacion
int RecepcionDeTrama ( void );
int LeerDatoDelBufferCircular ( void );
void CargarDatoAlBufferCircular ( unsigned char dato );
void Transmitir_RM ( void );
void Transmitir_RC ( void );

// valores del conversor AD
extern int ValoresMedidos [20];
extern int fMuestras ;
extern int fLr;
extern int fLg;

//Variables globales del modulo
extern unsigned char TiempoDeMuestreo ;
extern unsigned char ModoDeMuestreo;
extern unsigned char bufferRX [MAX_BUFFER];