#include "func.h"

//Timer
Ticker ticker;
//UART
RawSerial pc(USBTX, USBRX);

int main ( void )
{
    printf("INICIO PROGRAMA\r\n");
    //Inicializo interrupts
    ticker.attach(&interrupcion_timer,0.001);       //Timer 1ms    
    pc.attach(&interrupcion_UART);                  //UART
    
    while ( 1 ) {
        MaquinaDeEstados();
    }
}

//Interrupts

void interrupcion_UART() {
    unsigned char dato;
    dato = pc.getc();
    CargarDatoAlBufferCircular (dato);
}

void interrupcion_timer()
{
    static int tickMuestreo = 0;
    static int tickLr = 500;
    static int tickLg = 1000;
    tickMuestreo --;
    if ( tickMuestreo <= 0 ) {
        fMuestras= TRUE;
        tickMuestreo = TiempoDeMuestreo * 1000;
    }
    tickLr--;
    if ( tickLr<= 0 ) {
        if(fLr)
            fLr = FALSE;
        else
            fLr = TRUE;
        tickLr = 500;
    }   
    tickLg--;
    if ( tickLg<= 0 ) {
        if(fLg)
            fLg = FALSE;
        else
            fLg = TRUE;
        tickLg = 1000;
    }
}