#include "mbed.h"
#include "func.h"

//Salidas digitales
DigitalOut lr(LED_RED);
DigitalOut lg(LED_GREEN);
DigitalOut lb(LED_BLUE);

//Entrada ADC
AnalogIn ValorConversor(A0);

//Defino pines I2C
PinName const SDA = PTE25;
PinName const SCL = PTE24;

//Variables globales
int ValoresMedidos[20]; 
int fMuestras = TRUE;   
int fLr=ON, fLg=ON;
unsigned char TiempoDeMuestreo; //Guarda el set del tiempo entre muestras (asumo segundos)
unsigned char ModoDeMuestreo;//Guarda el modo en que se dispara el muestreo
unsigned char RX_in,RX_out; //indices de entrada y salida de datos del buffer circular
unsigned char bufferRX [MAX_BUFFER]; // buffer circular de recepcion

//INICIALIZO PERIF
TSIAnalogSlider tsi(ELEC0, ELEC1, 40);
MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
    
//MAQUINA DE ESTADOS
void MaquinaDeEstados ( void )
{
    static unsigned char Estados = DESHABILITADO , indice = 0;
    static int resultado;
    static double ValorAcelerometro, ValorTouch;
    
    switch ( Estados ) {
        
        case DESHABILITADO:
            //Sistema no configurado
            
            //Led rojo ON
            lr = ON;
            lg = OFF;
            lb = OFF;
            
            //Leo trama
            resultado = RecepcionDeTrama ( );
            if ( resultado == CONFIGURACION_RECIBIDA )
            {
                // Los valores de configuracion quedaron en:
                // TiempoDeMuestreo y ModoDeMuestreo
                printf("ESTADO REPOSO\r\n");
                Estados = REPOSO;
            }
            break;
        
        case REPOSO:
            // Sistema configurado, en Reposo (no mido datos)
            
            //Led verde parpadeando
            lr = OFF;
            blink_lg ();
            
            //Leo trama
            resultado = RecepcionDeTrama ( );
            
            // Si me consultan trasmito la configuracion
            if ( resultado == SOLICITUD_DE_CONFIGURACION )
                Transmitir_RC ( );
            
            // Si me consultan trasmito datos
            if((resultado == SOLICITUD_DE_MUESTRAS)&&(indice!=0))
                Transmitir_RM ( );
            
            // Si estoy configurado en A, leo Acelerometro
            if ( ModoDeMuestreo == 'A' )
            {
                ValorAcelerometro = acc.getAccZ()*1000; //1000 plano // 707 45° // <707 Casi vertical
                //Si estoy mas inclinado q 45°, voy a leer adc
                if ( ValorAcelerometro < SET_ACELEROMETRO ) {
                    Estados = CAPTURANDO_ADC;
                    printf("ESTADO MUESTREANDO\r\n");
                }
            }

            // Si estoy configurado en T, leo TSI
            if ( ModoDeMuestreo == 'T' )
            {
                //Si estoy tocando en 0.7, voy a leer adc
                ValorTouch  = tsi.readPercentage();
                if ( ValorTouch > SET_TOUCH )
                    Estados = CAPTURANDO_ADC;
            }
            break;
        
        case CAPTURANDO_ADC:
            //Sistema midiendo
            
            //Led verde ON
            lg = ON;
            
            //Me fijo que no se haya puesto la placa horizontal de nuevo
            if ( ModoDeMuestreo == 'A' )
            {
                ValorAcelerometro = acc.getAccZ()*1000;
                if ( ValorAcelerometro >= SET_ACELEROMETRO ) {
                    Estados = REPOSO;
                    printf("ESTADO REPOSO\r\n");
                }
            }

            //Me fijo que no se haya corrido el dedo del TSI
            if ( ModoDeMuestreo == 'T' )
            {
                ValorTouch  = tsi.readPercentage();
                if ( ValorTouch <= SET_TOUCH ) {
                    Estados = REPOSO;
                    printf("ESTADO REPOSO\r\n");
                }
            }

            //Si el timer me lo permite, leo ADC
            if ( fMuestras == TRUE )
            {
                fMuestras = FALSE;
                ValoresMedidos[ indice ] = ValorConversor*100;
                printf("GUARDADO %i \r\n",ValoresMedidos[ indice ]);
                indice ++;
                if ( indice == 20 ) {
                    //Si llegue a los 20 datos, me voy al estado FULL
                    Estados = DATOS_FULL;
                    printf("ESTADO FULL\r\n");
                }
            }
            break;
            
        case DATOS_FULL:
            //Sistema con 20 muestras tomadas.
            
            //Led rojo titilando
            lg = OFF;
            blink_lr();
            
            //Me pueden preguntar configuracion
            resultado = RecepcionDeTrama ( );
            if(resultado == SOLICITUD_DE_CONFIGURACION)
                Transmitir_RC ( );
            
            //Me pueden decir que libere los datos
            if(resultado == SOLICITUD_DE_MUESTRAS) {
                    Transmitir_RM ( );
                    printf("ESTADO DESHABILITADO\r\n");
                    Estados = DESHABILITADO; //Consigna no lo aclara, hago que vuelva a reposo
            }
            break;
    }
}

//PARPADEO LED ROJO
void blink_lr() {
    if(fLr)
        lr = ON;
    else
        lr = OFF;     
}

//PARPADEO LED VERDE
void blink_lg() {
    if(fLg)
        lg = ON;
    else
        lg = OFF;     
}

//SACO DATO, SI ESTABA VACIA LE MANDO -1
int LeerDatoDelBufferCircular ( void )
{
    int dato = -1;
    if ( RX_in != RX_out )
    {
        dato = bufferRX [RX_out];
        RX_out ++;
        if ( RX_out == MAX_BUFFER )
            RX_out = 0;
    }
    return dato;
}

//CARGO A LA COLA
void CargarDatoAlBufferCircular ( unsigned char dato )
{
    bufferRX [RX_in] = dato;
    RX_in ++;
    if ( RX_in == MAX_BUFFER )
        RX_in = 0;
}

// RTA AL PEDIDO DE DATOS >QM*1C<
void Transmitir_RM ( void )
{
    int i, myxor = 0;
    myxor = 'R';
    myxor = myxor ^ 'M';
    // aca tendria que hacer xor = xor ^ ',' PERO NO LO HAGO
    // CUANDO SALGO DEL for ME QUEDA SOBRANDO UNO
    for (i = 0 ; i < 20 ; i++ )
    {
        myxor = myxor ^ ValoresMedidos[i];
        myxor = myxor ^ ',';
    }

    printf(">RM");

    for (i = 0 ; i < 20 ; i++ )
    {
        printf( ",%02X" , ValoresMedidos[i] );
    }
    printf("*%02X<\r\n", myxor);
}

// RTA AL PEDIDO DE CONFIG >QC*12<
void Transmitir_RC ( void )
{
    int myxor = 0;
    myxor = 'R';
    myxor = myxor ^ 'C';
    myxor = myxor ^ ',';
    myxor = myxor ^ ( TiempoDeMuestreo + '0');
    myxor = myxor ^ ',';
    myxor = myxor ^ ModoDeMuestreo;
    printf(">RC,%d,%c*%02X<\r\n" , TiempoDeMuestreo , ModoDeMuestreo ,myxor);
}


//COMUNICACION

// analiza las tranas recibidas
// devuelve el resultado del analisis
// CONFIGURACION_RECIBIDA          1
// SOLICITUD_DE_CONFIGURACION      2
// SOLICITUD_DE_MUESTRAS           3
// si no es ningun caso anterior   -1
int RecepcionDeTrama ( void )
{
    static unsigned char EstadoRecepcion = ENCABEZADO;
    static unsigned char chequeoCalculado = 0 ;
    static unsigned char EstadoSiguienteComa ;
    static unsigned char  inx = 0 , accion;
    static char chequeo[ 3 ] ;
    static int salida = -1;
    int requerimiento = -1;
    int dato ;
    unsigned char chequeoRecibido , resultado;

    dato = LeerDatoDelBufferCircular ( );

    if ( dato != -1 )
    {
        switch ( EstadoRecepcion )
        {
            case ENCABEZADO :
                inx = 0;
                chequeoCalculado = 0;
                if ( dato == '>')
                    EstadoRecepcion = ACCION;
                break;
            case ACCION :
                if ( dato == 'S' || dato == 'Q')
                {
                    accion = (unsigned char) dato ;
                    chequeoCalculado = (unsigned char) dato ;
                    EstadoRecepcion = COMANDO;
                    break;
                }

                EstadoRecepcion = ENCABEZADO;
                if( dato == '>' ) {
                    EstadoRecepcion = ACCION;
                    inx = 0;
                    chequeoCalculado = 0;
                }
                break;
            case COMANDO :
                if ( accion == 'S' && dato == 'C') // Me setean la configuracion si es configuracion!
                {
                    salida = CONFIGURACION_RECIBIDA;
                    EstadoRecepcion = COMA;
                    EstadoSiguienteComa = TIEMPO_MUESTREO;
                    chequeoCalculado = chequeoCalculado ^ (unsigned char) dato ;
                    break;
                }

                if ( accion == 'Q' && dato == 'C') // Me consultan la configuracion!
                {
                    salida = SOLICITUD_DE_CONFIGURACION;
                    EstadoRecepcion = ASTERISCO;
                    chequeoCalculado = chequeoCalculado ^ (unsigned char) dato ;
                    break;
                }

                if ( dato == 'M') // me piden las muestras!
                {
                    salida = SOLICITUD_DE_MUESTRAS;
                    EstadoRecepcion = ASTERISCO;
                    chequeoCalculado = chequeoCalculado ^ (unsigned char) dato ;
                    break;
                }

                EstadoRecepcion = ENCABEZADO;
                if( dato == '>' ) {
                    EstadoRecepcion = ACCION;
                    inx = 0;
                    chequeoCalculado = 0;
                }
                break;
            
            case COMA :
                if ( dato == ',')
                {
                    EstadoRecepcion = EstadoSiguienteComa;
                    chequeoCalculado = chequeoCalculado ^ (unsigned char) dato ;
                    break;
                }
                EstadoRecepcion = ENCABEZADO;
                if( dato == '>' ) {
                    EstadoRecepcion = ACCION;
                    inx = 0;
                    chequeoCalculado = 0;
                }
                break;
            
            case TIEMPO_MUESTREO :
                if ( dato >= '1' && dato <= '7' )
                {
                    TiempoDeMuestreo = dato - '0';
                    EstadoRecepcion = COMA;
                    EstadoSiguienteComa = MODO_DE_MUESTREO;
                    chequeoCalculado = chequeoCalculado ^ (unsigned char) dato ;
                    break;
                }
                EstadoRecepcion = ENCABEZADO;
                if( dato == '>' ) {
                    EstadoRecepcion = ACCION;
                    inx = 0;
                    chequeoCalculado = 0;
                }
                break;
            
            case MODO_DE_MUESTREO :
                if ( dato == 'A' || dato == 'T' )
                {
                    ModoDeMuestreo = dato ;
                    EstadoRecepcion = ASTERISCO;
                    chequeoCalculado = chequeoCalculado ^ (unsigned char) dato ;
                    break;
                }
                EstadoRecepcion = ENCABEZADO;
                if( dato == '>' ) {
                    EstadoRecepcion = ACCION;
                    inx = 0;
                    chequeoCalculado = 0;
                }
                break;
            
            case ASTERISCO :
                if ( dato == '*' )
                {
                    EstadoRecepcion = CHEQUEO;
                    break;
                }
                EstadoRecepcion = ENCABEZADO;
                if( dato == '>' ) {
                    EstadoRecepcion = ACCION;
                    inx = 0;
                    chequeoCalculado = 0;
                }
                break;
            
            case CHEQUEO :
                if ( (dato >= '0' && dato <= '9') || (dato >= 'a' && dato <= 'f' ) || (dato >= 'A' && dato <= 'F' ))
                {
                    if (dato >= '0' && dato <= '9')
                        dato = dato - '0';
                    if (dato >= 'a' && dato <= 'f')
                        dato = dato - 'a' + 10;
                    if (dato >= 'A' && dato <= 'F')
                        dato = dato - 'A' + 10;
                    chequeo[ inx ] = (char) dato;
                    inx ++;
                    if ( inx == 2 )
                    {
                        chequeoRecibido = chequeo[ 0 ] * 16 + chequeo[ 1 ];
                        resultado = chequeoRecibido ^ chequeoCalculado;
                        if ( resultado == 0 )
                            EstadoRecepcion = FIN_DE_TRAMA;
                        else
                            EstadoRecepcion = ENCABEZADO;
                    }
                    break;
                }
                EstadoRecepcion = ENCABEZADO;
                if( dato == '>' ) {
                    EstadoRecepcion = ACCION;
                    inx = 0;
                    chequeoCalculado = 0;
                }
                break;
            
            case FIN_DE_TRAMA :
                if ( dato != '<' )
                    requerimiento = -1;
                else
                    requerimiento = salida;
                EstadoRecepcion = ENCABEZADO;
                if( dato == '>' ) {
                    EstadoRecepcion = ACCION;
                    inx = 0;
                    chequeoCalculado = 0;
                }
                break;
        }
    }
    return requerimiento;
}