#include "mbed.h"
#include "IR_Def.h"
#include "hcsr04.h"

#define CAT0_PIN PC_1     // 11 PC_3        переставили с катодом 7
#define CAT1_PIN PC_3     // 7  PC_2        переставили с катодом 6
#define CAT2_PIN PB_0     // 4 PF_5         переставили с катодом 5
#define CAT3_PIN PC_2     // 2   PA_0       переставили с катодом 4
#define CAT4_PIN PA_4     // 1 PF_10
#define CAT5_PIN PA_1    // 10 PF_2    
#define CAT6_PIN PC_0    // 5  PD_5
#define CAT7_PIN PF_1    // 3 PH_0

#define ANO0_PIN PB_4     // 12 PC_0
#define ANO1_PIN PB_5     // 9 PF_3
#define ANO2_PIN PB_3     // 8 PB_0
#define ANO3_PIN PB_10     // 6 PA_3

//------------------------------------
// Hyperterminal configuration
// 9600 bauds, 8-bit data, no parity
//------------------------------------
Serial pc(SERIAL_TX, SERIAL_RX);  
InterruptIn IR(PC_12);
DigitalOut myled(LED1);
Timer T;  
Ticker  system_clock;  
Ticker pult;                                             //This will be used to increment a counter every msec inside it's ISR
Ticker display;                   
Ticker distancee;
Ticker muzika;
AnalogOut Da(PA_5);
//DigitalOut myled(LED2);
DigitalOut cathodes[8] = {
  DigitalOut(CAT0_PIN), 
  DigitalOut(CAT1_PIN), 
  DigitalOut(CAT2_PIN), 
  DigitalOut(CAT3_PIN), 
  DigitalOut(CAT4_PIN), 
  DigitalOut(CAT5_PIN), 
  DigitalOut(CAT6_PIN), 
  DigitalOut(CAT7_PIN), 
};
DigitalOut anodes[4] = {
  DigitalOut(ANO0_PIN), 
  DigitalOut(ANO1_PIN), 
  DigitalOut(ANO2_PIN), 
  DigitalOut(ANO3_PIN), 
};

int p = 0;
int o=0;
void IR_ISR();                                                      //ISR for decoding the IR signal
void dummy_ISR();                                                   //Required so that 'IR_ISR' is not called on both rising and falling edges of IR signal at the same time
void sys_tick(); 
int v=0;
uint8_t state = 0;                       //State variable for IR state machine
uint8_t Rx_count = 0;                                //Counter to count no. of bits received
uint32_t Rx_buf = 0;                 //To store recevied IR data
char Rx_flag = 0;                    //Flag which indicates that a valid IR command was received
uint32_t Rx_rep_count = 0;           //To keep track of how many repeat pulses are received
uint32_t Rx_rep_timeout_count = 0;   //Timer which clears the previously received IR command, once it reaches the set limit
uint32_t T_buf = 0;                  //Buffer to hold value of timer T
char Rx_ignore_rep_flag = 0;         //0 => Do not ignore repeat pulses 

uint8_t digits[] = {0x03, 0x9F, 0x25, 0x0D, 0x99, 0x49,  0x41, 0x1F, 0x01, 0x09, 0xFD, 0x91,0x89, 0x83};
//DigitalOut trig(PA_3);
//DigitalIn echo(PD_7);
HCSR04  usensor(PB_13,PB_14);
unsigned int dist=0;
int flag1, flag2, flag3 = 0;
int i,j,k,m,size=0;

void fireUpSign(int signNum){
  anodes[signNum] = 1;
}

void shutDownSign(int signNum){
  anodes[signNum] = 0;
}
void setDigit(int digit){
  for(int isd=0; isd < 8; isd++){
     ((digits[digit] & (1<<(7-isd))) > 0) ? cathodes[isd] =1 : cathodes[isd] =0;
  }  
}
void fireUpAllSigns(){
  fireUpSign(0);
  fireUpSign(1);
  fireUpSign(2);
  fireUpSign(3);
}

void shutDownAllSigns(){
  shutDownSign(0);
  shutDownSign(1);
  shutDownSign(2);
  shutDownSign(3);
}
void ddisplay ()
{
            setDigit(p); 
            fireUpSign(3); 
            wait_us(3000);
            shutDownAllSigns();
            setDigit(i); 
            fireUpSign(2); 
            wait_us(3000);
            shutDownAllSigns();
            setDigit(j);
            fireUpSign(1);
            wait_us(3000); 
            shutDownAllSigns();
            setDigit(k);
            fireUpSign(0);
            wait_us(3000); 
            shutDownAllSigns();
            //IR.fall(&IR_ISR);
            //IR.rise(&dummy_ISR); 
            if(i>9)
                {
                j++;
                i=0;
                }
            if(j>9)
            {
                k++;
                j=0;
                i=0;
                }
                /*if(i == 1)
                {
                    myled = !myled;
                    wait_ms(300);
                    i = 0;
                }*/
    }
void ddistance ()
{
    usensor.start();
    dist=usensor.get_dist_cm();
    //IR.fall(&IR_ISR);
    //IR.rise(&dummy_ISR); 
    }  
    
void sys_tick()
{
    if(Rx_rep_timeout_count < 0xFFFF) { //Do not increment counter beyond 0xFFFF to prevent roll-over
        ++Rx_rep_timeout_count;       //Increment this counter every 1msec.
    }
}

void ppult ()
{
                  //  if(o==0)
     // {
    //IR.mode(PullNone);
    //wait_ms(20);
  // IR.fall(&IR_ISR);
  // IR.rise(&dummy_ISR); 
//    }           
} 
    
int main()
{
    int verh;
    int nij;
    while(1) {  
           //if (o==0)
      // {
      // display.attach(&ddisplay, 0.02);   
     //  distancee.attach(&ddistance, 0.02);
      // pult.attach(&ppult, 2);
      ddisplay ();
      ddistance();
    //   }
        verh = 80;
        nij = 10; 
        if(dist >verh)
            {
            flag1=1;
            }
        if(flag1==1 && dist < nij)
            {
            flag2=1;
            }
        if (flag1==1 && flag2==1 && dist>verh)
        {
            flag3=1;
            }   
        if( flag1==1 && flag2==1 && flag3==1)
            {
            flag1=0;
            flag2=0;
            flag3=0;
            i++;
            }
     if (v==1)
                { 
               // pc.printf(" RX= %x " , Rx_buf);

 
        if(Rx_buf == 0xbf40ff00)
    {
        //pc.printf("5");
        p=0;
        j=0;
        i=0;
        k=0;
        
      }
    
        if(Rx_buf == 0xf609ff00)
    {
       i++;
            if(i>9)
                {
                j++;
                i=0;
                }
            if(j>9)
            {
                k++;
                j=0;
                i=0;
                }
       {
           }
       // pc.printf("9");
      }
    
        if(Rx_buf == 0xf807ff00)
    {
       //pc.printf("7");
        if (p>9)
        {
            p=0;
            }
            else
            {
                p++;
                }
      }
    
        if(Rx_buf == 0xe619ff00)
    {
      if(i+j+k<p)
        {
           i=0;
           j=0;
           k=0;
           p=0;
            }  
      if(i>=p)
      {
          i=i-p;
          }
      else if(i<p)
      {
           if(j==0)
           {
               k=k-1;
               j=j+10-(p-i);
               i=i+10;
               i=i-p;
               }
            else if(j!=0)
            {
                i=i+10;
                i=i-p;
                j=j-1;
                }
        }
    
        
       //pc.printf("0");
      }
      v=0;
      }
    
    // if(o==0)
    // {
    //IR.mode(PullNone);
    wait_ms(12);
   IR.fall(&IR_ISR);
   IR.rise(&dummy_ISR); 
    //}  
 }
}

void dummy_ISR()
{
    //Do nothing
}

void IR_ISR()
{
    o=1;
    display.detach();
    distancee.detach();
    //pult.detach();
    if(state == 0) {
        T.stop();               //Stop timer
        T.reset();              //Reset timer
        T.start();              //Start timer
        IR.rise(&IR_ISR);       //Set IR interrupt to occur on rising edge
        IR.fall(&dummy_ISR);
        state = 1;              //Go to next state
        Rx_count = 0;           //Clear the received bits counter
    } else if(state == 1) {
        
        T.stop();                          //Stop timer
        T_buf = (uint32_t)T.read_us();     //Read timer
        T.reset();                         //Reset timer
        T.start();                         //Start timer
        IR.fall(&IR_ISR);                  //Set IR interrupt to occur on falling edge
        IR.rise(&dummy_ISR);
 
        if(T_buf <= IR_9000us_UL && T_buf >= IR_9000us_LL) {  //Check for preamble start pulse(9ms)
            state = 2;  //Go to next state
        } else {
            state = 0; //Reset the state machine
        }
    } else if(state == 2) {
    
        T.stop();                          //Stop timer
        T_buf = (uint32_t)T.read_us();     //Read the value in timer
        T.reset();                         //Reset timer
        T.start();                         //Start timer
        IR.fall(&IR_ISR);                  //Set IR interrupt to occur on falling edge
        IR.rise(&dummy_ISR);
 
        if(T_buf <= IR_4500us_UL && T_buf >= IR_4500us_LL) { //Check for preamble space(4.5ms)
        
            state = 3;                  //Go to next state
            Rx_rep_timeout_count = 0;   //Reset counter
            Rx_rep_count = 0;           //Reset the repeat pulse counter
        } else if(T_buf <= IR_2250us_UL && T_buf >= IR_2250us_LL) { //Check for repeat pulse(2.25ms)
            state = 0;                      //Reset the state machine
 
            if(Rx_rep_count < 0xFFFF) {
                if(Rx_rep_timeout_count < IR_rep_timeout_ms) {  //Only increment the repeat pulse counter if the delay between two successive repeat pulses is less than 135msec.
                    Rx_rep_timeout_count = 0;                   //Reset the counter everytime a valid repeat pulse is received
                    ++Rx_rep_count;
                } else {                                         //Invald repeat pulse received
                    Rx_rep_count = 0;                            //Reset counter
                    Rx_flag = 0;                                 //Clear the flag to indicate that an IR command was not received
                    Rx_buf = 0;                                  //Clear the previously received command
                }
            }
            goto ahead;                    //Repeat the previous command
        } else { //Wrong pulse
            Rx_rep_count = 0;     //Reset counter
            state = 0;                       //Reset the state machine
        }
    } else if(state == 3) {
        T.stop();                      //Stop timer
        T_buf = T.read_us();          //Read the value in timer
        T.reset();                     //Reset timer
        T.start();                     //Start timer
        IR.fall(&IR_ISR);              //Set IR interrupt to occur on falling edge
        IR.rise(&dummy_ISR);
v=1 ;
 
        if(T_buf <= IR_1_UL_us && T_buf >= IR_1_LL_us) { //Check if bit is '1'(2.25ms)
            ++Rx_count;              //Increment the bit counter
            Rx_buf >>= 1;
            Rx_buf |= 0x80000000;     //Shift in a '1' from the left side
            
            state = 3;               //Remain in current state
        } else if(T_buf <= IR_0_UL_us && T_buf >= IR_0_LL_us) { //Check if bit is '0'(1.12ms)
            ++Rx_count;         //Increment the bit counter
            Rx_buf >>= 1;        //Shift in a '0' from the left side
            state = 3;          //Remain in current state
        } else { //Invalid data received
            Rx_count = 0;//Reset the bit counter
            state = 0;   //Reset state m/c

        }
 
        if(Rx_count == 32) { //Check if all 32 bits have been received
            state = 0; 
                 //Reset state m/c
 
ahead:
 
            if(!((Rx_rep_count > 0) && (Rx_ignore_rep_flag == 1))) {
                Rx_flag = 1;                             //Set this flag for repeat pulses only if repeat pulses are to be considered
            }
            Rx_rep_timeout_count = 0;         //Reset the counter everytime a valid command is received
        }
    }
     o=0;
}    
