/*********************************************************************
*
* HTTP_SERVER.h
* 
* Mauricio Martins Donatti
* mauricio.donatti@lnls.br
*
* Electronics Instrumentation Group - GIE
* Brazilian Synchrotron Light Laboratory (LNLS)
* Brazilian Center for Research in Energy and Materials (CNPEM)
*
* March 2020
*
*******************************************************************/

#ifndef HTTP_SERVER_H
#define HTTP_SERVER_H

#include "mbed.h"
#include "EthernetInterface.h"
#include <string>

#define MAX_BUFFER_SIZE         1024
#define WEBSERVERPORT           80
#define QUEUED_REQUESTS         3
#define DEVICE_NAME             "LNLS_4CH_001\0"
#define WEBSERVER_TIMEOUT_MS    1500


#define DEBUG

#ifdef DEBUG

extern Serial pc;
#define HTTP_PRINTF(fmt, ...)       pc.printf("HTTP: " fmt "\r\n", ##__VA_ARGS__)

#else

#define HTTP_PRINTF(fmt, ...)           __NOP()

#endif //Config enabled DEBUG



using namespace std;

// HttpServer class
//
// This is the class to make a mbed a simple HTTP Server.
class HttpServer
{
public:
    HttpServer();
    ~HttpServer();
    
    // HTTP SERVER Initialization.
    //
    //  This function should be called first of all.
    //  @return result of init() as boolean.
    //  @retval TRUE SACCESS
    //  @retval FALSE
    //
    bool init(EthernetInterface* eth,char *file,int file_size);
    
    // Run the surver service while listening flag is true.
    //
    //  @return state ending.
    //  @retval TRUE at error end.
    //  @retval FALSE at normal end.
    //
    bool run();
    
    char *html_file;                //Pointer to HTML file
    int html_size;
    
    char buffer[MAX_BUFFER_SIZE];   //receive and transmit buffer
    int n_recv;
    int buf_len;
    int status_code;                //http status code
    char reason_phrase[30];         //http reason phrase
    
    char httpmethod[20];            //http method
    char filepath[40];              //file requested
    char http_ver[20];              //http version

    //  Handlers
    TCPSocket socket;               //  TCP server
    TCPSocket* client;              //  TCP server connection clerk
    
    nsapi_error_t status;
};

#endif