/*********************************************************************
*
* Simple HTTP Server library
* 
* Mauricio Martins Donatti
* mauricio.donatti@lnls.br
*
* Electronics Instrumentation Group - GIE
* Brazilian Synchrotron Light Laboratory (LNLS)
* Brazilian Center for Research in Energy and Materials (CNPEM)
*
* March 2020
*
*******************************************************************/

#include "http_server.h"

char c; //aux variable

HttpServer::HttpServer()
{
    buffer[0] = '\0';   //constructor    
}

HttpServer::~HttpServer()
{
}
bool HttpServer::init(EthernetInterface* eth,char *file,int file_size)
{
    HTTP_PRINTF("DEBUG MODE");
    
    html_file = file;
    html_size = file_size;
    
    if(socket.open(eth)==NSAPI_ERROR_OK)
        HTTP_PRINTF("Socket Opened\n\r");
    else
        HTTP_PRINTF("Error opening socket\n\r");

    if(socket.bind(80)==NSAPI_ERROR_OK)
        HTTP_PRINTF("Socket Bind Success\n\r");
    else
        HTTP_PRINTF("Bind Error\n\r");

    if(socket.listen(QUEUED_REQUESTS)==NSAPI_ERROR_OK)
        HTTP_PRINTF("Socket Listen Success\n\r");
    else
        HTTP_PRINTF("Listen Error\n\r");
        
    return true;
}

bool HttpServer::run()
{   
    client = socket.accept(&status);
    HTTP_PRINTF("After accept\n\r");
    if(status==NSAPI_ERROR_OK)
    {
        client->set_timeout(WEBSERVER_TIMEOUT_MS);
        n_recv = client->recv(buffer,MAX_BUFFER_SIZE);
        switch(n_recv) {
            case 0:
                HTTP_PRINTF("received buffer is empty.");
                status_code = 400;
                sprintf(reason_phrase,"No Request");
                httpmethod[0]    = '\0';
                filepath[0]      = '\0';
                http_ver[0]      = '\0';
                break;  
            case -1:
                HTTP_PRINTF("failed to read data from client.");
                status_code = 500;
                sprintf(reason_phrase,"Internal Server Error");
                httpmethod[0]    = '\0';
                filepath[0]      = '\0';
                http_ver[0]      = '\0';
                break;
            default:
                HTTP_PRINTF("Received Data: %d",strlen(buffer));
                HTTP_PRINTF("-->\r\n");
                HTTP_PRINTF("%.*s[End of Request]",strlen(buffer),buffer);
                //  get HTTP method, File path, HTTP version
                strcpy(httpmethod,strtok(buffer, " ")); 
                strcpy(filepath,strtok(NULL, " "));
                strcpy(http_ver,strtok(NULL, " "));
                HTTP_PRINTF("httpmethod: %s", httpmethod);
                HTTP_PRINTF("file path:  %s", filepath);
                HTTP_PRINTF("http ver :  %s", http_ver);
                break;
        }
        
        if (httpmethod[0] == '\0') {
            buffer[MAX_BUFFER_SIZE - 1] = '\0';
            sprintf(buffer,"%s %d %s\r\nConnection: Close\r\n\r\n", http_ver, status_code, reason_phrase);
            HTTP_PRINTF("echo back done.");
        }
        
        //  Response
        if (strcmp(httpmethod,"GET") == 0 ) //GET request - always index.html stoed in index_html
        {
            HTTP_PRINTF("GET request incomming.");
            HTTP_PRINTF("httpmethod: %s", httpmethod);
            buffer[MAX_BUFFER_SIZE-1] = '\0';
            status_code = 200;
            sprintf(reason_phrase,"OK");

            sprintf(buffer,"%s %d %s\r\nConnection: Close\r\nContent-Type: text/html\r\nKeep-Alive: timeout=15\r\n\r\n", http_ver, status_code, reason_phrase);
            client->send(buffer,strlen(buffer));
            client->send(html_file,html_size);
        } 
        if (strcmp(httpmethod,"POST") == 0 ) //POST request - javascript request
        {
            HTTP_PRINTF("POST request incomming.");
            status_code = 200;
            sprintf(reason_phrase,"OK");

            sprintf(buffer,"%s %d %s\r\nConnection: Close\r\n\r\n", http_ver, status_code, reason_phrase);
            client->send(buffer,strlen(buffer));
            
            if(strcmp(filepath,"/read_data")==0){
                sprintf(buffer,"0 1.25 2 200e-12 10e9 0 0 1.25 1 100e-12 10e9 0 0 1.25 0.5 50e-12 10e9 0 0 1.25 0.2 20e-12 10e9 0");
                //sprintf(buffer,"%d %e %e %s %s\0",(*CH).range,(*CH).voltage,(*CH).current,full_scale[(*CH).range].c_str(),ranges[(*CH).range].c_str());
                client->send(buffer,strlen(buffer));
                HTTP_PRINTF("Response: %s",buffer);
                /*
                //Temporary: update current:
                (*CH).current = (*CH).current+1e-12;
                if((*CH).current > 10e-12)
                    (*CH).current = -10e-12; */
            }
            
            if(strncmp(filepath,"/range",strlen("/range"))==0)
            {
                sscanf(filepath,"/range=%c",&c);
                if(c>='0'&& c<='4')
                {
                    //(*CH).range = c - '0';
                    //set_range((*CH).range);
                    //(*CH).new_data = 1;
                    HTTP_PRINTF("Changing range: %d",c - '0');
                }
            }
            
            if(strcmp(filepath,"/device_name")==0)
            {
                sprintf(buffer,"%s",DEVICE_NAME);
                client->send(buffer,strlen(buffer));
            }
        }
        client->close();      
    } 
    else
        HTTP_PRINTF("Accept Error: %d\n\r",status);

    return 0;
}