#include "mbed.h"
#include "EthernetInterface.h"
#include "TCPSocket.h"
#include "http_server.h"
#include "LocalFileSystem.h"

#define PORT                1000
#define SOCKET_TIMEOUT_MS   2000

//Serial interface
Serial pc(USBTX, USBRX,115200);

//Initialize network interface
EthernetInterface eth;

nsapi_error_t status;
int n_bytes;
SocketAddress eth_addr;
TCPSocket socket;
TCPSocket* client;
int i;
Thread socket_thread;
Thread web_server_thread;
char recv_buffer[40];
char html_page[10000];
int html_page_size;

HttpServer web_server;

DigitalOut heartbeat(LED1);
DigitalOut socket_led(LED2);
DigitalOut webserver_led(LED3);

//There is a configuration file that can be accessed through usb in order to configure the device
LocalFileSystem local("local");     //Create the local filesystem under the name "local"

FILE *html_file;                //Pointer to HTML file

void socket_port()
{
    if(socket.open(&eth)==NSAPI_ERROR_OK)
        pc.printf("Socket Opened\n\r");
    else
        pc.printf("Error opening socket\n\r");

    if(socket.bind(PORT)==NSAPI_ERROR_OK)
        pc.printf("Socket Bind Success\n\r");
    else
        pc.printf("Bind Error\n\r");

    if(socket.listen(QUEUED_REQUESTS)==NSAPI_ERROR_OK)
        pc.printf("Socket Listen Success\n\r");
    else
        pc.printf("Listen Error\n\r");
    
    while(1)
    {
        client = socket.accept(&status);
        
        pc.printf("After accept\n\r");
        socket_led = !socket_led;
        if(status==NSAPI_ERROR_OK)
        {
            client->set_timeout(SOCKET_TIMEOUT_MS);
            n_bytes = client->recv(recv_buffer,40);
            if(n_bytes>0)
            {
                for(i=0;i<n_bytes;i++)
                    pc.putc(recv_buffer[i]);
                switch(recv_buffer[0])
                {
                    case 'a':
                        pc.printf("a received\n\r");
                        client->send("a=2\n\r",5);
                        break;    
                    case 'b':
                        pc.printf("b received\n\r");
                        client->send("b=5\n\r",5);
                        break;   
                    default:
                        pc.printf("ERROR>NOT-A-CMD\n\r");
                        client->send("ERROR>NOT-A-CMD\n\r",17);
                }
                ThisThread::sleep_for(2000);
            }
            else
                pc.printf("Receiving Error: %d\n\r",n_bytes);
            client->close();
        }  
        else
            pc.printf("Accept Error: %d\n\r",status);
    }
}

void web_server_func()
{
    web_server.init(&eth,html_page,html_page_size);
    while(1)
    {
        web_server.run(); 
        webserver_led = !webserver_led;   
    }
}

int main()
{
    pc.printf("Starting Firmware\n\r");
    
    // Initializng webserver
    html_file = fopen("/local/index.htm","r");  // Open "index.html" on the local file system for reading
    if(html_file==NULL){  //If file doesnt exist
        pc.printf("File not found: index.htm\n\r");
    }
    else
    {                 //File exists
        pc.printf("HMTL file found\n\r");  
        fseek(html_file, 0, SEEK_SET);  
        html_page_size = 0;
        while (!feof(html_file))
            html_page[html_page_size++]= getc(html_file);
        if(feof(html_file))
            html_page_size--;
    }  
    
    // Initialising Ethernet Interface
    do{
        status = eth.connect();
        if(status == NSAPI_ERROR_OK || status == NSAPI_ERROR_IS_CONNECTED)
            pc.printf("Internet connection established\n\r");
        else
            pc.printf("No internet connnection: Error Code: %d\n\r", status);   
    }while(status != NSAPI_ERROR_OK && status != NSAPI_ERROR_IS_CONNECTED);
    
    // Checking IP Address (DHCP Mode)
    if(eth.get_ip_address(&eth_addr)==NSAPI_ERROR_OK)
        pc.printf("IP address: %s\n\r", eth_addr.get_ip_address() ? eth_addr.get_ip_address() : "None");
    else
        pc.printf("DHCP failure - acquiring the IP address has failed\n\r");
    
    //while(1){}
    
    
    socket_thread.start(socket_port);
    web_server_thread.start(web_server_func);

    while (true) {
        heartbeat = !heartbeat;
        ThisThread::sleep_for(1000);
    }
}     