#include "mbed.h"
#include "LPC17xx.h"
#include "TextLCD.h"
#include "rtos.h"
#include "Thread.h"

DigitalOut vsense(p23);
DigitalOut asense(p24);
DigitalIn apace(p22);
DigitalIn vpace(p21);

Ticker rate_monitor;


TextLCD lcd(p15, p16, p17, p18, p19, p20, TextLCD::LCD20x4); // rs, e, d4-d7

volatile int beats = 0;
volatile double bpm = 0;

DigitalOut led_apace(LED1);
DigitalOut led_vpace(LED2);
DigitalOut led_asense(LED3);
DigitalOut led_vsense(LED4);

Serial serial_in(USBTX, USBRX);


int test_time_count;
int curr_test;
int minwaitV = 200;
int minwaitA = 400;

int obs_int = 10;


int needs_num_input = 0;

enum mode {RANDOM,MANUAL,TEST};
mode test_curr_mode = RANDOM;
Timer t;


void test_LRI(){
    Timer test_timer;
    
    test_timer.start();
    // wait for next vpace
    while(vpace != 1){}
    serial_in.printf("LRI: The separation between Ventricle events was %i ", test_timer.read_ms());
    
}

void test_PVARP(){
    Timer test_timer;
    
    test_timer.start();
    
    while(apace != 1){}
    serial_in.printf("PVARP: The separation between Ventricular and Atrial events was %i ", test_timer.read_ms());
    
    
}

void test_VRP(){
    Timer test_timer;
    
    test_timer.start();
    
    while(vpace != 1 && vsense != 1){}
    serial_in.printf("VRP: The separation between Ventricle events was %i ", test_timer.read_ms());
    
    
}


void test_AVI(){
    Timer test_timer;
    
    test_timer.start();
    
    while(vpace != 1){}
    serial_in.printf("AVI: The separation between Atrial and Ventricle events was %i ", test_timer.read_ms());
    
    
}

void test_AVI2(){
    Timer test_timer;
    
    test_timer.start();
    
    while(apace != 1){}
    serial_in.printf("LRI-AVI: The separation between Ventricle and Atrial events was %i ", test_timer.read_ms());
    
    
}
    



void random_heart(void const *args)
{
    t.reset();
    t.start();
    while(1){
    while(test_curr_mode == RANDOM) {
        int r = rand();
        if(r%2 == 0) {
            if(t.read_ms() > minwaitA) {
                led_asense = 1;
                asense = 1;
                Thread::wait(10);
                asense = 0;
                led_asense = 0;
                t.reset();

            }else{
                Thread::wait(100);
            }
        } else {
            if(t.read_ms() > minwaitV) {
                led_vsense = 1;
                vsense = 1;
                Thread::wait(10);
                vsense = 0;
                beats++;
                led_vsense = 0;
                t.reset();

            }else{
                Thread::wait(100);
            }
        }
        
        Thread::wait(150);



    }
    }
}

void pm_beat_update(void const *args){
    while(1){
        lcd.locate(0,0);
        lcd.printf("BPM: %.1f   ", bpm);
    }
}


void kbd_intrp()
{

    char a = serial_in.getc();
    serial_in.printf("char was " + a);
    if(needs_num_input) {
        // DO O handling
        needs_num_input = 0;
        return;
    }

    if(a == 'R') {
        test_curr_mode = RANDOM;
    } else if(a == 'T') {
        test_curr_mode = TEST;
    } else if(a == 'M') {
        test_curr_mode = MANUAL;
    }

    if(a == 'A' && test_curr_mode == MANUAL) {
        asense = 1;
        Thread::wait(10);
        asense = 0;
    }

    if(a == 'V' && test_curr_mode == MANUAL) {
        vsense = 1;
        Thread::wait(10);
        vsense = 0;
    }

}

void rec_apace(){
    led_apace = 1;
    Thread::wait(10);
    led_apace = 0;   
}

void rec_vpace(){
    led_vpace = 1;
    Thread::wait(10);
    led_vpace = 0;   
}

void heart_response1(void const *args){
    while(1){
        if(apace == 1){
            rec_apace();
        }

    }
    
}

void heart_response2(void const *args){
    while(1){
        
        if(vpace == 1){
            rec_vpace();
        }
    }
    
}

// interrupt function
void interrupt_and_run_test()
{
    test_curr_mode = TEST;
    serial_in.printf("--BEGIN TEST--");
    while(vpace != 1){}
    while(vpace == 1){}
    test_LRI();
    while(vpace != 1){}
    while(vpace == 1){}
    test_PVARP();
    while(vpace != 1){}
    while(vpace == 1){}
    test_VRP();
    while(apace != 1){}
    while(apace == 1){}
    test_AVI();
    serial_in.printf("--END TEST--");
    test_curr_mode = RANDOM;
}

void update_display() {
    bpm = beats / (double) obs_int * 60;
    //reset count
    beats = 0;
}

int main(void)
{
    
    
    

    Thread t3(random_heart, (void *)"");
    Thread t2(heart_response1, (void *)"");
    Thread t4(heart_response2, (void *)"");
    Thread t5(pm_beat_update, (void *)"");

    rate_monitor.attach(&update_display, obs_int);
    char a = 'Z';


    while(1) {

        if(serial_in.readable()) {
            a = serial_in.getc();
             serial_in.printf("GOT %c!!",a);
            
            if (needs_num_input) {
                if (a >= '0' && a <= '9') {
                    // update observation interval
                    obs_int = (a - '0' + 1) * 5;
                    needs_num_input = 0;
                    rate_monitor.attach(&update_display, obs_int);
                    serial_in.printf("Set observation interval to %d seconds\n", obs_int);
                } else {
                    serial_in.printf("Expected numeric key\n");
                }
            }

            if(a == 'R') {
                serial_in.printf("GOT R!!");
                test_curr_mode = RANDOM;
            } else if(a == 'T') {
                 serial_in.printf("GOT T!!");
                test_curr_mode = TEST;
                interrupt_and_run_test();
            
            } else if(a == 'M') {
                 serial_in.printf("GOT M!!");
                test_curr_mode = MANUAL;
            }
            else if(a == 'O') {
                 serial_in.printf("GOT obs!!");
                needs_num_input = 1;
            }

            if(a == 'A' && test_curr_mode == MANUAL) {
                asense = 1;
                led_asense = 1;
                Thread::wait(10);
                led_asense = 0;
                asense = 0;
            }

            if(a == 'V' && test_curr_mode == MANUAL) {
                vsense = 1;
                led_vsense = 1;
                Thread::wait(10);
                led_vsense = 0;
                vsense = 0;
            }
            
            while(serial_in.readable()){
                serial_in.printf("GOT TO CONSUME!!",a);
                serial_in.getc();
            }


        }
    }
    

}