#include "TextLCD.h"
#include "Mutex.h"
#include "rtos.h"
#include "Thread.h"
using namespace rtos;

//Define LCD 
TextLCD lcd(p15, p16, p17, p18, p19, p20, TextLCD::LCD20x4); // rs, e, d4-d7

//Individual Mutex for each chopstick
Mutex chopsticks[5];

// Eating routine
void eat(const int* phil) {
    // All chopsticks (0-4) are behind an individual mutex
    // Each philosopher picks up the even chopstick of the left right pair first, ie. they alternate between which
    // they pick up first based on their ID
    
    if((int)phil % 2 == 0){    
        chopsticks[(int)phil % 5].lock();
        chopsticks[(int)phil - 1].lock();
    }else{
        chopsticks[(int)phil - 1].lock();
        chopsticks[(int)phil % 5].lock();
    }
           
    // we locate the part of the LCD, put the char to signifiy the philosopher eating
    lcd.locate((int)phil,0);
    lcd.putc((int)phil + 48);
    
    //The eating period is between 1000 and 2000 ms
    int eatPeriod = rand()%1000 + 1000;
    // The thread waits while the philosopher is eating
    Thread::wait(eatPeriod);
    
    //After eating, the philosopher puts down the chopsticks and clears himself from the LCD
    lcd.locate((int)phil,0);
    lcd.printf(" ");
    chopsticks[(int)phil - 1].unlock();
    chopsticks[(int)phil % 5].unlock();
}

// General thread behavioral routine, eating and waiting (philosophizing)
void philosophizeAndEat(void const *args) {
    while (true) {
        //Decide a time between 5-10 seconds between eating requests
        int waitPeriod = rand()%5000 + 5000;
        // wait until time elapses to eat again
        Thread::wait(waitPeriod);
        
        //Performing the eating routine
        eat((const int*)args); 
    }
}

// setup routine, create all philosophers
int main() {
    // Initialize 5 philosopher threads with IDs
    Thread t3(philosophizeAndEat, (void *)3);
    Thread t2(philosophizeAndEat, (void *)2);
    Thread t4(philosophizeAndEat, (void *)4);
    Thread t5(philosophizeAndEat, (void *)5);
    philosophizeAndEat((void *)1);
}
