
#include "mbed.h"
#include <stdio.h>
#include <errno.h>
#include "stm32l475e_iot01_tsensor.h"
#include "nvstore.h"

// Block devices
#if COMPONENT_SPIF
#include "SPIFBlockDevice.h"
#endif

#if COMPONENT_DATAFLASH
#include "DataFlashBlockDevice.h"
#endif 

#if COMPONENT_SD
#include "SDBlockDevice.h"
#endif 

#include "HeapBlockDevice.h"
// File systems
#include "LittleFileSystem.h"
#include "FATFileSystem.h"

EventQueue queue(32 * EVENTS_EVENT_SIZE);
Thread thread;
Ticker ticker;


// Physical block device, can be any device that supports the BlockDevice API
/*SPIFBlockDevice bd(
        MBED_CONF_SPIF_DRIVER_SPI_MOSI,
        MBED_CONF_SPIF_DRIVER_SPI_MISO,
        MBED_CONF_SPIF_DRIVER_SPI_CLK,
        MBED_CONF_SPIF_DRIVER_SPI_CS);*/

#define BLOCK_SIZE 512
HeapBlockDevice bd(16384, BLOCK_SIZE);

// File system declaration
LittleFileSystem fs("fs");

InterruptIn button(USER_BUTTON);


static FILE *file;
volatile int counter = 0;

void readSensors() {
    float temperature = 0;
    temperature = BSP_TSENSOR_ReadTemp();
    fprintf(file, "%f\n", temperature);
    fflush(file);
    fflush(stdout);    
    printf("Temperature Saved\n");
}

void readAndPrintFile() {
    fflush(stdout);
    fflush(file);
    fseek(file, 0, SEEK_SET);
    float temperature;
    while(!feof(file)) {
        fscanf(file, "%f", &temperature);
        printf("Temperature: %f\n", temperature);
    }
    fflush(stdout);
}


void printData() {
    queue.call(readAndPrintFile);    
}
void readData() {
    queue.call(readSensors);
}


// Entry point for the example
int main() {
    thread.start(callback(&queue, &EventQueue::dispatch_forever));
    BSP_TSENSOR_Init();
    button.rise(&printData);
    
    printf("--- Mbed OS filesystem example ---\n");

    // Mount the filesystem
    printf("Mounting the filesystem\n");
    fflush(stdout);
    int err = fs.mount(&bd);
    printf("%s\n", (err ? "Fail :(" : "OK"));
    if (err) {
        // Reformat if we can't mount the filesystem
        // this should only happen on the first boot
        printf("ERROR -> Formatting due to no filesystem exists");
        fflush(stdout);
        err = fs.reformat(&bd);
        printf("%s\n", (err ? "Fail :(" : "OK"));
        if (err) {
            error("ERROR -> %s (%d)\n", strerror(-err), err);
        }
    }

    // Open the numbers file
    printf("Opening \"/fs/numbers.txt\"\n");
    fflush(stdout);
    file = fopen("/fs/numbers.txt", "r+");
    printf("%s\n", (!file ? "Fail :(" : "OK"));
    if (!file) {
        // Create the numbers file if it doesn't exist
        printf("Creating a new file\n");
        fflush(stdout);
        file = fopen("/fs/numbers.txt", "w+");
        printf("%s\n", (!file ? "Fail :(" : "OK"));
        if (!file) {
            error("ERROR -> %s (%d)\n", strerror(errno), -errno);
        }
        
        printf("Seeking file\n");
        fflush(stdout);
        err = fseek(file, 0, SEEK_SET);
        printf("%s\n", (err < 0 ? "Fail :(" : "OK"));
        if (err < 0) {
            error("ERROR -> %s (%d)\n", strerror(errno), -errno);
        }
    }
    

    ticker.attach(&readData, 60);
}
