#include "mbed.h"


DigitalOut led1(LED1);
DigitalOut led2(LED2);


// Blink function toggles the led in a long running loop
void blink(DigitalOut *led) {    
    *led = !*led;
    wait(1);
    *led = !*led;
}

// Spawns a thread to run blink for 5 seconds
int main() {
    while (true) {
        Thread thread;
        Thread thread2;
        
        thread.start(callback(blink, &led1));
        thread.join();
        
        thread2.start(callback(blink, &led2));
        thread2.join();
    }
}
