#include "mbed.h"

#include "stm32l475e_iot01_accelero.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);

Thread blinkThread;
Thread fetchThread;

static bool onLongSide;
static bool onShortSide;
static bool flat;

void updateLeds(int led_1, int led_2, int led_3) {
    led1 = led_1;
    led2 = led_2;
    led3 = led_3;
}

void toggleLeds() {
    while (true) {
        if (flat) {
            led1 = !led1;
        } else if (onLongSide) {
            led2 = !led2;
        } else if (onShortSide) {
            led3 = !led3;
        } else {
            led1 = !led1;
            led2 = !led2;
            led3 = !led3;
        }
                
        wait(0.2);
    }
}

int main()
{
    
    int16_t pDataXYZ[3] = {0};
    BSP_ACCELERO_Init();
    
    blinkThread.start(toggleLeds);
    
    
    while(1) {
        BSP_ACCELERO_AccGetXYZ(pDataXYZ);
        
        // Readings
        int x = pDataXYZ[0];
        int y = pDataXYZ[1];
        int z = pDataXYZ[2];
        
        printf("ACCELERO_X = %d\n", x);
        printf("ACCELERO_Y = %d\n", y);
        printf("ACCELERO_Z = %d\n", z);

        onLongSide = x < 0 && y > 950 && z < 100;        
        onShortSide = (x < -1000 && y < 0 && z < 100) || (x > 950 && y > 0 && z < 100);
        flat = x < 50 && x > -50 && y < 50 && y > -50 && z > 1000;
        
        printf("Is on long side: %d\n", onLongSide);
        printf("Is on short side: %d\n", onShortSide);
        printf("Is on flat side: %d\n", flat);
        
        if (flat) {
            updateLeds(1, 0, 0);
        } else if (onLongSide) {
            updateLeds(0, 1, 0);
        } else if (onShortSide) {
            updateLeds(0, 0, 1);
        } else {
            updateLeds(1, 1, 1);
        }
        
        printf("=======================================\n");
        wait(0.2);
    }
}
