#include "mbed.h"

DigitalOut led1(LED1);
InterruptIn button(USER_BUTTON);
EventQueue queue(32 * EVENTS_EVENT_SIZE);
Thread t;

time_t last_click;

void fall_handler(void) {
    printf("Button pressed\r\n");
    
    time_t current = time(NULL);
    
    if (current - last_click <= 2) {
        // Turn on the led, wait one sec, and then turn it off
        led1 = !led1;
        wait(0.5);
        led1 = !led1;
    }
    
    // Update the last_click time
    last_click = current;
}

int main() {
    // We start by setting a last click bogus time
    last_click = time(NULL);
    
    // Start the event queue
    t.start(callback(&queue, &EventQueue::dispatch_forever));
    button.fall(queue.event(fall_handler));
    
    printf("Setup complete\n");
}
