
#include "mbed.h"
#include <stdio.h>
#include <errno.h>
#include "stm32l475e_iot01_accelero.h"

// Block devices
#if COMPONENT_SPIF
#include "SPIFBlockDevice.h"
#endif

#if COMPONENT_DATAFLASH
#include "DataFlashBlockDevice.h"
#endif 

#if COMPONENT_SD
#include "SDBlockDevice.h"
#endif 

#include "HeapBlockDevice.h"
// File systems
#include "LittleFileSystem.h"
#include "FATFileSystem.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
Ticker toggle_led;

EventQueue queue(32 * EVENTS_EVENT_SIZE);
Thread thread;
int maximum( int, int, int);
//int maximum( int a, int b, int c );

// Physical block device, can be any device that supports the BlockDevice API
/*SPIFBlockDevice bd(
        MBED_CONF_SPIF_DRIVER_SPI_MOSI,
        MBED_CONF_SPIF_DRIVER_SPI_MISO,
        MBED_CONF_SPIF_DRIVER_SPI_CLK,
        MBED_CONF_SPIF_DRIVER_SPI_CS);*/

#define BLOCK_SIZE 512
HeapBlockDevice bd(16384, BLOCK_SIZE);

// File system declaration
LittleFileSystem fs("fs");

// Set up the button to trigger an erase
InterruptIn irq(BUTTON1);
void erase() {
    printf("Initializing the block device... ");
    fflush(stdout);
    int err = bd.init();
    printf("%s\n", (err ? "Fail :(" : "OK"));
    if (err) {
        error("error: %s (%d)\n", strerror(-err), err);
    }

    printf("Erasing the block device... ");
    fflush(stdout);
    err = bd.erase(0, bd.size());
    printf("%s\n", (err ? "Fail :(" : "OK"));
    if (err) {
        error("error: %s (%d)\n", strerror(-err), err);
    }

    printf("Deinitializing the block device... ");
    fflush(stdout);
    err = bd.deinit();
    printf("%s\n", (err ? "Fail :(" : "OK"));
    if (err) {
        error("error: %s (%d)\n", strerror(-err), err);
    }
}

static FILE *file;
volatile int counter = 0;

void getDataFromSensors() {
    int16_t pDataXYZ[3] = {0};
    BSP_ACCELERO_AccGetXYZ(pDataXYZ);
    
    bool isHorizontal = pDataXYZ[2] > 900 || pDataXYZ[2] < -900;
    bool isOnLongEdge = pDataXYZ[1] > 900 || pDataXYZ[1] < -900;
    bool isOnShortEdge = pDataXYZ[0] > 900 || pDataXYZ[0] < -900;
    
    if(isHorizontal) {
        fprintf(file, "%d\n", 1);
    } else if(isOnLongEdge) {
        fprintf(file, "%d\n", 2);
    } else if(isOnShortEdge) {
        fprintf(file, "%d\n", 3);
    } else {
        fprintf(file, "%d\n", 4);
    }
    fflush(file);
    fflush(stdout);    
}

void readFile() {
    
    int countLed1 = 0;
    int countLed2 = 0;
    int countLed3 = 0;
    
    fflush(stdout);
    fflush(file);
    
    fseek(file, 0, SEEK_SET);
    int ledNumber;
    while(!feof(file)) {
        fscanf(file, "%d", &ledNumber); 
        if(ledNumber == 1){
            countLed1 += 1;    
        } else if(ledNumber == 2){
            countLed2 += 1;    
        } else if(ledNumber == 3){
            countLed3 += 1;    
        }
    }
    
    bool isLed1 = led1 >= led2 && led1 >= led3;
    bool isLed2 = led2 >= led1 && led2 >= led3;
    bool isLed3 = led3 >= led1 && led3 >= led2;

    if(isLed1) {
        led1 = 1;
        led2 = 0;
        led3 = 0;
    } else if (isLed2) {
        led1 = 0;
        led2 = 1;
        led3 = 0;
    } else if (isLed3) {
        led1 = 0;
        led2 = 0;
        led3 = 1;
    }
    
    fflush(stdout);
    int err = fclose(file);
    printf("%s\n", (err < 0 ? "Fail :(" : "OK"));
    if (err < 0) {
      error("error: %s (%d)\n", strerror(err), -err);
    }
    err = fs.unmount();
    printf("%s\n", (err < 0 ? "Fail :(" : "OK"));
    if (err < 0) {
        error("error: %s (%d)\n", strerror(-err), err);
    }
      
    printf("Mbed OS filesystem example done!\n"); 
}

void toggleLed() {
    queue.call(getDataFromSensors);
    counter += 1;
    if(counter == 1000) {
        toggle_led.detach();
        queue.call(readFile);
    }
}


// Entry point for the example
int main() {
    thread.start(callback(&queue, &EventQueue::dispatch_forever));
    BSP_ACCELERO_Init();
    printf("--- Mbed OS filesystem example ---\n");

    // Setup the erase event on button press, use the event queue
    // to avoid running in interrupt context
    irq.fall(mbed_event_queue()->event(erase));

    // Try to mount the filesystem
    printf("Mounting the filesystem... ");
    fflush(stdout);
    int err = fs.mount(&bd);
    printf("%s\n", (err ? "Fail :(" : "OK"));
    if (err) {
        // Reformat if we can't mount the filesystem
        // this should only happen on the first boot
        printf("No filesystem found, formatting... ");
        fflush(stdout);
        err = fs.reformat(&bd);
        printf("%s\n", (err ? "Fail :(" : "OK"));
        if (err) {
            error("error: %s (%d)\n", strerror(-err), err);
        }
    }

    // Open the numbers file
    printf("Opening \"/fs/numbers.txt\"... ");
    fflush(stdout);
    file = fopen("/fs/numbers.txt", "r+");
    printf("%s\n", (!file ? "Fail :(" : "OK"));
    if (!file) {
        // Create the numbers file if it doesn't exist
        printf("No file found, creating a new file... ");
        fflush(stdout);
        file = fopen("/fs/numbers.txt", "w+");
        printf("%s\n", (!file ? "Fail :(" : "OK"));
        if (!file) {
            error("error: %s (%d)\n", strerror(errno), -errno);
        }
    }
    
    toggle_led.attach(&toggleLed, 0.01);
    

}
