/* Copyright (c) 2010-2011 mbed.org, MIT License
*
* Permission is hereby granted, free of charge, to any person obtaining a copy of this software
* and associated documentation files (the "Software"), to deal in the Software without
* restriction, including without limitation the rights to use, copy, modify, merge, publish,
* distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all copies or
* substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
* BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
* DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#include "MAX7219.h"

// define max7219 registers
#define max7219_reg_noop         0x00
#define max7219_reg_digit0       0x01
#define max7219_reg_digit1       0x02
#define max7219_reg_digit2       0x03
#define max7219_reg_digit3       0x04
#define max7219_reg_digit4       0x05
#define max7219_reg_digit5       0x06
#define max7219_reg_digit6       0x07
#define max7219_reg_digit7       0x08
#define max7219_reg_decodeMode   0x09
#define max7219_reg_intensity    0x0a
#define max7219_reg_scanLimit    0x0b
#define max7219_reg_shutdown     0x0c
#define max7219_reg_displayTest  0x0f

#define Max7219_Time        125

#ifndef MaxInUse
#define MaxInUse 1
#endif


DigitalOut DIN(PTA7);
DigitalOut CLK(PTB0);
DigitalOut LOAD(PTA5);

MAX7219::MAX7219() {
    DIN=0;
    CLK=0;
    LOAD = 1;    
}

MAX7219::~MAX7219() { }

void MAX7219::putByte(uint8_t data) {
  uint8_t i = 8;
  uint8_t mask;
  
  while(i > 0) {
    mask = 0x01 << (i - 1);      // get bitmask
    CLK = 0;   					 // tick
    if (data & mask){            // choose bit
      DIN = 1;					 // send 1
    }else{
      DIN = 0;					 // send 0
    }
    CLK = 1;   					 // tock
    --i;                         // move to lesser bit
    //wait_us(Max7219_Time);
  }
}

void MAX7219::Init(uint8_t ND,uint8_t DM,uint8_t IN)
{
	uint8_t e;
	//initiation of the max 7219
  	maxAll(max7219_reg_scanLimit, ND);      
  	maxAll(max7219_reg_decodeMode, DM);  // using an led matrix (not digits)
  	maxAll(max7219_reg_shutdown, 0x01);    // not in shutdown mode
  	maxAll(max7219_reg_displayTest, 0x00); // no display test
   	for (e=1; e<=8; e++) {    // empty registers, turn all LEDs off 
    	maxAll(e,0);
  	}
  	maxAll(max7219_reg_intensity, 0x0f & IN);    // the first 0x0f is the value you can set
                                                  // range: 0x00 to 0x0f
	
}

void MAX7219::maxSingle( uint8_t reg, uint8_t col) {    
//maxSingle is the "easy"  function to use for a single max7219

  LOAD = 0;                      // begin     
  putByte(reg);                  // specify register
  putByte(col);					 // put data   
  LOAD = 0;                      // and load da stuff
  LOAD = 1;                      
}

void MAX7219::maxAll(uint8_t reg, uint8_t col) {    // initialize  all  MAX7219's in the system
  uint8_t c = 0;
  LOAD = 0;                      // begin     
  for ( c =1; c<= MaxInUse; c++) {
  putByte(reg);  // specify register
  putByte(col);  // put data
    }
  LOAD = 0;                      
  LOAD = 1;                      
}

void MAX7219::maxOne(uint8_t maxNr, uint8_t reg, uint8_t col) {    
//maxOne is for addressing different MAX7219's, 
//while having a couple of them cascaded

  uint8_t c = 0;
  LOAD = 0;                      // begin     

  for ( c = MaxInUse; c > maxNr; c--) {
    putByte(0);    // means no operation
    putByte(0);    // means no operation
  }

  putByte(reg);  // specify register
  putByte(col);//((data & 0x01) * 256) + data >> 1); // put data 

  for ( c =maxNr-1; c >= 1; c--) {
    putByte(0);    // means no operation
    putByte(0);    // means no operation
  }

  LOAD = 0;                      // and load da stuff
  LOAD = 1;                      
}

void MAX7219::Power(uint8_t Mode)
{
  	if(Mode>=1){  	
  		maxAll(max7219_reg_shutdown, 0x01);    // not in shutdown mode
	}
	else{
  		maxAll(max7219_reg_shutdown, 0x00);    // in shutdown mode
  	}			
}
	


