/* Copyright (c) 2010-2011 mbed.org, MIT License
*
* Permission is hereby granted, free of charge, to any person obtaining a copy of this software
* and associated documentation files (the "Software"), to deal in the Software without
* restriction, including without limitation the rights to use, copy, modify, merge, publish,
* distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all copies or
* substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
* BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
* DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#ifndef M24CXX_H
#define M24CXX_H

#include "mbed.h"

class M24CXX
{
public:
    
    M24CXX(PinName SDA, PinName SCL,int Adr);
    ~M24CXX();
    
    /* Write just one byte on memory */
    
    int Write(int EEAddres, uint8_t Data);
    int write(int EEAddres, uint8_t Data);
    
    
    /* How to write more than once byte on memory
    
#include "mbed.h"
#include "M24CXX.h"

  PinName const SDA = PTB4;
  PinName const SCL = PTB3;

int main()
{
    int alfa=0;
    uint8_t datas[12] = {'L','u','c','a','s',' ','M','o','r','a','e','s'};
    
    M24CXX memory (SDA,SCL,0);
    
    printf("Memory Started\r\n");
    while (true) {
        printf("Try to write\r\n");
        alfa = memory.writePage(0x00,(uint8_t*)datas,sizeof(datas));
        printf("Result is %d\r\n",alfa);
        wait(0.5);
    }
}

*/   
    int writePage(int EEAddres, uint8_t* Data, int Length);
    int WritePage(int EEAddres, uint8_t* Data, int Length);
    
    
    /* Read a single byte from memory  */
    
    uint8_t read(int EEAddress);    
    uint8_t Read(int EEAddress);
    
    
    /* Read sequential of bytes from memory */
        
    // memory.readPage(0,13,(uint8_t*) datas);
        
    void readPage(int EEAddress,int Length,uint8_t* Data);
    void ReadPage(int EEAddress,int Length,uint8_t* Data);
  
private:
    I2C m_i2c;
    int m_Address;

};

#endif
