/* Copyright (c) 2010-2011 mbed.org, MIT License
*
* Permission is hereby granted, free of charge, to any person obtaining a copy of this software
* and associated documentation files (the "Software"), to deal in the Software without
* restriction, including without limitation the rights to use, copy, modify, merge, publish,
* distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all copies or
* substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
* BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
* DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#include "M24CXX.h"

#ifndef MaxTimes
#define MaxTimes 5
#endif

#ifndef AdrLength
#define AdrLength 16
#endif

M24CXX::M24CXX(PinName SDA, PinName SCL,int Adr):m_i2c(SDA,SCL), m_Address(Adr){
    m_i2c.frequency(100000);
}

M24CXX::~M24CXX() { }

int M24CXX::write(int EEAddres, uint8_t Data){
    uint8_t MT = MaxTimes;
    uint8_t Ackno=1;
    uint8_t AckOld=1;
    
    uint8_t MAd;
    uint8_t MHAd,MLAd;
    uint8_t Mdata;
    
    
    
    MAd = (0b10100000) | 0x00; //m_Address;
    MHAd = (EEAddres >> 8) & 0xff;
    MLAd = (EEAddres & 0xff);
    Mdata = Data & 0xff;
    
    
    while(Ackno==1 && MT>0)
    {
        m_i2c.start();
        //printf("Ack is %d\r\n",Ackno);  
        //printf("Memory Ad %d\r\n",m_Address);
        //printf("Try to send Memory Address %d\r\n",MAd);
        AckOld = m_i2c.write(MAd);
        Ackno = Ackno && AckOld; 
        //printf("Ack is %d\r\n",Ackno);  
        
        if(AdrLength == 16)
        {
            //printf("Try to send EE High Address %d\r\n",MHAd);
            AckOld = m_i2c.write(MHAd);
            Ackno = Ackno && AckOld; 
            //printf("Ack is %d\r\n",Ackno);  
         }
            
        //printf("Try to send EE Low Address %d\r\n",MLAd);
        AckOld = m_i2c.write(MLAd);
        Ackno = Ackno && AckOld; 
        //printf("Ack is %d\r\n",Ackno);  
        
        //printf("Try to send Data %d\r\n",Mdata);
        AckOld = m_i2c.write(Mdata);
        Ackno = Ackno && AckOld; 
        //printf("Ack is %d\r\n",Ackno);  
        
        m_i2c.stop();
        
        wait(1);
        
        if(Ackno == 0){
            MT--;
            if( MT>0){
                Ackno = 1;
            }
        }
        else
        {
            MT=0;
        }
    }        
    
    return Ackno;
}

int M24CXX::Write(int EEAddres, uint8_t Data)
{
    return write(EEAddres,Data);
} 
    
int M24CXX::writePage(int EEAddres, uint8_t* Data, int Length)
{
    uint8_t MT = MaxTimes;
    uint8_t Ackno=1;
    uint8_t AckOld=1;
    
    uint8_t MAd;
    uint8_t MHAd,MLAd;
    
    
    MAd = (0b10100000) | m_Address;
    MHAd = (EEAddres >> 8) & 0xff;
    MLAd = (EEAddres & 0xff);
    
    
    while(Ackno==1 && MT>0)
    {
        m_i2c.start();
        //printf("Ack is %d\r\n",Ackno);  
        //printf("Memory Ad %d\r\n",m_Address);
        //printf("Try to send Memory Address %d\r\n",MAd);
        AckOld = m_i2c.write(MAd);
        Ackno = Ackno && AckOld; 
        //printf("Ack is %d\r\n",Ackno);  
        
        if(AdrLength == 16)
        {
            //printf("Try to send EE High Address %d\r\n",MHAd);
            AckOld = m_i2c.write(MHAd);
            Ackno = Ackno && AckOld; 
            //printf("Ack is %d\r\n",Ackno);  
         }
            
        //printf("Try to send EE Low Address %d\r\n",MLAd);
        AckOld = m_i2c.write(MLAd);
        Ackno = Ackno && AckOld; 
        //printf("Ack is %d\r\n",Ackno);  
        
        int i=0;
        
        for(i=0;i<Length;i++){
            //printf("Try to send Data %d\r\n",Data[i]);
            //printf("Try to send Data %c\r\n",Data[i]);
            AckOld = m_i2c.write(Data[i]);
            Ackno = Ackno && AckOld; 
            //printf("Ack is %d\r\n",Ackno);  
        }
        m_i2c.stop();
        
        if(Ackno == 0){
            MT--;
            if( MT>0){
                Ackno = 1;
            }
        }
        else
        {
            MT=0;
        }
    }        
    
    return Ackno;   
}

int M24CXX::WritePage(int EEAddres, uint8_t* Data, int Length)
{
    return writePage(EEAddres,(uint8_t*) &Data, Length);
}

    
uint8_t M24CXX::read(int EEAddres)
{
    uint8_t Read;
    uint8_t AckOld=1, Ackno=1;
    
    m_i2c.start();
    
    m_i2c.write((0b10100000) | m_Address);    
    
    if(AdrLength == 16)
    {
        AckOld = m_i2c.write((EEAddres >> 8) & 0xff);
        Ackno = Ackno && AckOld;  
    }
            
    AckOld = m_i2c.write((EEAddres & 0xff));
    Ackno = Ackno && AckOld; 
    
    m_i2c.start();
        
    m_i2c.write((0b10100001) | m_Address);    
    
    Read = m_i2c.read(0);
    
    return Read;    
}

uint8_t M24CXX::Read(int EEAddres)
{
    return read(EEAddres);
}

void M24CXX::readPage(int EEAddres,int Length,uint8_t* Data)
{
    int i;
    uint8_t AckOld=1, Ackno=1;
    
    m_i2c.start();
    
    m_i2c.write((0b10100000) | m_Address);    
    
    if(AdrLength == 16)
    {
        AckOld = m_i2c.write((EEAddres >> 8) & 0xff);
        Ackno = Ackno && AckOld;  
    }
            
    AckOld = m_i2c.write((EEAddres & 0xff));
    Ackno = Ackno && AckOld; 
    
    m_i2c.start();
        
    m_i2c.write((0b10100001) | m_Address);    
    
    
    for(i=0;i<Length-1;i++){
        Data[i] = m_i2c.read(1);
    }
        
    Data[Length] = m_i2c.read(0);
}
    
void M24CXX::ReadPage(int EEAddres,int Length,uint8_t* Data)
{
    readPage(EEAddres,Length,(uint8_t*)Data);
}
    
    


