#include "mbed.h"

// estabelece a comunicação serial com o PC para debug
Serial pc(USBTX, USBRX);

// inicializa os botões como interrupções
InterruptIn botao_SW1(D2);
InterruptIn botao_SW2(D7);

// foram usados timers para fazer o debounce no click dos botões
Timer debounceSW1Fall;
Timer debounceSW2Fall;
Timer debounceSW1Rise;
Timer debounceSW2Rise;

// o timer de avanço serve para a função de acionamento automático do vidro
Timer avanco;

// leitura do shunt de corrente para identificar o esmagamento
AnalogIn Shunt(A5);
float Corrente;

// as saídas servem para acionar o motor do vidro na direção especificada
DigitalOut saida_IN1(D10);
DigitalOut saida_IN2(D8);
DigitalOut saida_EN(D9);

bool SW1 = 1;
bool SW2 = 1;
bool IN1 = 0;
bool IN2 = 0;

// as funções abaixo estabelecem o comportamento do programa ao serem identificadas as interrupções.
// em linhas gerais, é feito o debounce através delas, e alterados os valores de variáveis que
// identificam a ação do usuário.
void DSW1Fall(){
    
    if (debounceSW1Fall.read_ms() > 200) {
        SW1 = 0;
        debounceSW1Fall.reset();
        pc.printf("DSW1Fall \n\r");
        
        avanco.start();
        }
    }
    
void DSW2Fall(){
    
    if (debounceSW2Fall.read_ms() > 200) {
        SW2 = 0;
        debounceSW2Fall.reset();
        pc.printf("DSW2Fall \n\r");
        }
    }
    
void DSW1Rise(){
    if (debounceSW1Rise.read_ms() > 200) {
        if(avanco.read_ms() >= 500) {
            avanco.stop();
            avanco.reset();
        }
        // a função avanço mantém a variável verdadeira sem a necessidade do click no botão
        else if(avanco.read_ms() < 500){
            SW1 = 1;
        }
        debounceSW1Rise.reset();
        pc.printf("DSW1Rise \n\r");
        }
    }
    
void DSW2Rise(){
    if (debounceSW2Rise.read_ms() > 200) {
        SW2 = 1;
        debounceSW2Rise.reset();
        pc.printf("DSW2Rise \n\r");
        }
    }
    
int main() {
    // attach das funções de debounce
    debounceSW1Fall.start();
    debounceSW2Fall.start();
    debounceSW1Rise.start();
    debounceSW2Rise.start();
    
    botao_SW1.rise(&DSW1Rise);
    botao_SW1.fall(&DSW1Fall);
    botao_SW2.rise(&DSW2Rise);
    botao_SW2.fall(&DSW2Fall);
    
    while(1){
        
        // aquisita o valor de corrente do motor
        Corrente = 3.3f*Shunt;
        
        // se a corrente observada for maior que o limite estabelecido, 
        // recua por 200ms, suficiente para evitar o esmagamento
        if (Corrente > 0.7f){
            if (IN1 && !IN2){
                saida_IN1 = IN2;
                saida_IN2 = IN1;
                wait_ms(250);
            }
            else if (IN2 && !IN1){
                saida_IN1 = IN2;
                saida_IN2 = IN1;
                wait_ms(250);
            }
            saida_IN1 = 0;
            saida_IN2 = 0;
            SW1 = 1;
            SW2 = 1;
            wait_ms(1000);
        }
         
         // se a chave 1 for idntificada, o motor recua   
        if (SW1 == 0){
            IN1 = 1; IN2 = 0;
            saida_EN = 1;
            saida_IN1 = IN1;
            saida_IN2 = IN2;
            wait(0.01);
            }
        
        // se a chave 2 for identificada, o motor avança
        else if (SW2 == 0){
            IN1 = 0; IN2 = 1;
            saida_EN = 1;
            saida_IN1 = IN1;
            saida_IN2 = IN2;
            wait(0.01);
            }
        // caso nenhuma ação seja tomada,  nada é movimentado
        else {
            IN1 = 0; IN2 = 0;
            saida_EN = 0;
            saida_IN1 = IN1;
            saida_IN2 = IN2;
            wait(0.01);
            }
        wait(0.01);
    }
}
