#include "mbed.h" 

// estabele a comunicação serial com o PC para debug
Serial pc(USBTX, USBRX);

// define as portas analógicas do joystick (x e y) e o click para tilt down
AnalogIn Joy_X(A3);
AnalogIn Joy_Y(A5);
DigitalIn Joy_B(PC_13);

// as saídas digitais são usadas para controle da rotação do motor CC (direção e habilitação)
// A - controle do motor em X; B - controle do motor em Y.
DigitalOut saida_IN1a(D5);
DigitalOut saida_IN1b(A0);
DigitalOut saida_IN2a(D4);
DigitalOut saida_IN2b(A1);
DigitalOut saida_ENa(D2);
DigitalOut saida_ENb(A4);

float JX;
float JY;
bool JB;
bool JBb = 0;


int main() {
    // o estado inicial dos motores é desligado
    saida_ENa = 0;
    saida_ENb = 0;
    
    while(1){
        // aquisita os valores do joystick (posição xy e botão)
        JX = Joy_X;
        JY = Joy_Y;
        JB = Joy_B;
        
        // o botão central do joystick determina a função tilt-down do retrovisor.
        // em um veículo, representa uma chave acoplada ao mecanismo de seleção da marcha ré
        if (JB == 0){
            // assim que pressionado, move o espelho em Y (para baixo) durante 500ms
            saida_ENb = 1;
            saida_ENa = 0;
            saida_IN1b = 0;
            saida_IN2b = 1;
            wait_ms(500);
            saida_IN2b = 0;
            
            // espera a marcha ré ser desengatada
            while(JB == 0){
                }
            
            // assim que a marcha é desengatada, o espelho volta a posição original
            saida_IN1b = 1;
            saida_IN2b = 0;
            wait_ms(500);
            saida_IN1b = 0;
             }
        // a condição checa se a posição do joystick em X está fora do "ponto morto"
        if (JX >= 0.6f || JX <= 0.4f ){
            // caso esteja, aciona o a ponte H A, que aciona o movimento em X 
            saida_ENa = 1;
            saida_ENb = 0;
            
            // a direção é definida pela posição do joystick (acima ou abaixo do ponto morto)
            if (JX >= 0.6f){
                saida_IN1a = 0;
                saida_IN2a = 1;
                }
            
            else if (JX <= 0.4f){
                saida_IN1a = 1;
                saida_IN2a = 0;
                }
            }
        
        // a mesma lógica de movimentação em X é usada em Y  
        else if (JY >= 0.6f || JY <= 0.4f ){
            saida_ENb = 1;
            saida_ENa = 0;
            
            if (JY >= 0.6f){
                saida_IN1b = 0;
                saida_IN2b = 1;
                }
                
            else if (JY <= 0.4f){
                saida_IN1b = 1;
                saida_IN2b = 0;
                }    
            }
        // caso nenhuma condição seja aceita, os motores permanecem desligados.   
        else{
            saida_ENa = 0;
            saida_ENb = 0;
            }
    }
}
