#include "mbed.h"
#include "XBee.h"

Serial pc(USBTX, USBRX);

RawSerial xbeeUart(p28, p27, 9600);
XBee xbee(xbeeUart);

// serial high
uint8_t shCmd[] = {'S','H'};
// serial low
uint8_t slCmd[] = {'S','L'};
// association status
uint8_t assocCmd[] = {'A','I'};

uint8_t disableApiCmd[] = {'A', 'P'};
uint8_t disableApiData = 0;

AtCommandRequest atRequest = AtCommandRequest(shCmd);
AtCommandResponse atResponse = AtCommandResponse();

uint8_t messageData[] = {'H', 'e', 'l', 'l', 'o'};
Tx16Request txReq(0x0003, messageData, 5);
TxStatusResponse txStatus;

void sendAtCommand();

void loop() {
    // get SH
    sendAtCommand();

    // set command to SL
    atRequest.setCommand(slCmd);
    sendAtCommand();

    // Say hello!
    xbee.send(txReq);
    if (xbee.readPacket(5000)) {
        if (xbee.getResponse().getApiId() == TX_STATUS_RESPONSE) {
            xbee.getResponse().getTxStatusResponse(txStatus);

            // get the delivery status, the fifth byte
            if (txStatus.getStatus() == SUCCESS) {
            	// success.  time to celebrate
             	pc.printf("Message was sent and received!\r\n");
            } else {
            	// the remote XBee did not receive our packet. is it powered on?
             	pc.printf("Message was not acknowledged\r\n");
            }
        }
    } else if (xbee.getResponse().isError()) {
        pc.printf("Error reading packet.  Error code: %d\r\n", xbee.getResponse().getErrorCode());
    } else {
        // local XBee did not provide a timely TX Status Response.  Radio is not configured properly or connected
        pc.printf("Transmit timeout\r\n");
    }

    // Disable API mode
    // atRequest.setCommand(disableApiCmd);
    // atRequest.setCommandValue(&disableApiData);
    // atRequest.setCommandValueLength(1);
    // sendAtCommand();

    // Demo complete
    while (1) {};
}

int main()
{
    pc.printf("Waiting for Xbee to initialize...\r\n");
    wait(5);
    pc.printf("Xbee should be ready\r\n");

    while(1) {
        loop();
    }
}

void sendAtCommand() {
    pc.printf("Sending command to the XBee\r\n");

    // send the command
    xbee.send(atRequest);

    // wait up to 5 seconds for the status response
    if (xbee.readPacket(5000)) {
        // got a response!

        // should be an AT command response
        if (xbee.getResponse().getApiId() == AT_COMMAND_RESPONSE) {
            xbee.getResponse().getAtCommandResponse(atResponse);

            if (atResponse.isOk()) {
                pc.printf("Command [%c%c] was successful!\r\n", atResponse.getCommand()[0], atResponse.getCommand()[1]);

                if (atResponse.getValueLength() > 0) {
                    pc.printf("Command value length is ");
                    pc.printf("%d\r\n", atResponse.getValueLength());

                    pc.printf("Command value: ");

                    for (int i = 0; i < atResponse.getValueLength(); i++) {
                        pc.printf("%x ", atResponse.getValue()[i]);
                    }

                    pc.printf("\r\n");
                }
            }
            else {
                pc.printf("Command return error code: %x\r\n", atResponse.getStatus());
            }
        } else {
            pc.printf("Expected AT response but got %x\r\n", xbee.getResponse().getApiId());
        }
    } else {
        // at command failed
        if (xbee.getResponse().isError()) {
            pc.printf("Error reading packet.  Error code: %x\r\n", xbee.getResponse().getErrorCode());
        }
        else {
            pc.printf("No response from radio\r\n");
        }
    }
}

