#include "mbed.h"
#include "C12832.h"
#include "USBKeyboard.h"

AnalogIn potentiometer(p19);

C12832 lcd(p5, p7, p6, p8, p11);

DigitalIn joystick_center(p14);
DigitalOut led1(LED1), led2(LED2), led3(LED3), led4(LED4);

USBKeyboard keyboard;

void led_routine() {
    while (true) {
        led4 = 0; 
        led1 = 1;
        wait(0.2);
        led1 = 0;  
        led2 = 1;
        wait(0.2);
        led2 = 0; 
        led3 = 1;
        wait(0.2);
        led3 = 0; 
        led4 = 1;
        wait(0.2);
    }
}

char pot_to_letter(float value) {
    return 'a' + (char)(value * 26);
}

int main() {
    Thread led_thread;
    led_thread.start(led_routine);
    lcd.cls();
    lcd.printf("mbed kerbal board...");
    while (true) {
        if (joystick_center.read())
            keyboard.putc(pot_to_letter(potentiometer.read()));
        lcd.locate(0, 9);
        lcd.printf("potentiometre: %c", pot_to_letter(potentiometer.read()));
        wait(0.1f);
    }
    return 0;
}
