import tornado.httpserver
import tornado.websocket
import tornado.ioloop
import tornado.web
import socket
import json
'''
This is a simple Websocket Echo server that uses the Tornado websocket handler.
Please run `pip install tornado` with python of version 2.7.9 or greater to install tornado.
This program will echo back the reverse of whatever it recieves.
Messages are output to the terminal for debuggin purposes. 
''' 
 
class WSHandler(tornado.websocket.WebSocketHandler):
    def open(self):
        print 'New Connection'
      
    def on_message(self, message):
 
        print 'Message Received ! '

        print message
        
        if (message != None):
            decrypt = json.loads(message);
        

        if (decrypt["id"] == 'Joystick_center' ):
                print 'Joystick Center !\n'
                self.write_message("ACK") 
               
        elif (decrypt["id"] == 'Joystick_nord' ):
                print 'Joystick Nord !\n' 
                self.write_message("ACK") 

 
    def on_close(self):
        print 'connection closed'
 
    def check_origin(self, origin):
        return True
 
application = tornado.web.Application([
    (r'/ws', WSHandler),
])
 
 
if __name__ == "__main__":
    http_server = tornado.httpserver.HTTPServer(application)
    http_server.listen(1235)
    myIP = socket.gethostbyname(socket.gethostname())
    print '*** Websocket Server Started at %s***' % myIP
    tornado.ioloop.IOLoop.instance().start()