/*
 * MyLab.h
 *
 * 
 *      Author: Favre Lucas
 */

#ifndef MYLAB_LIB_MYLAB_H_
#define MYLAB_LIB_MYLAB_H_
#include "MMA7660FC.h"
#include "C12832.h"

#include "mbed.h"

#define NUMDAT 10000
#define DLY 250

#define ADDR_MMA7660 (0x4C << 1) // Addresse esclave de l'accéléromètre MMA7660FC

extern MMA7660FC Acc;
extern Serial ser;
extern C12832 lcd;

extern BusOut leds;


class MyLab {
public:
    MyLab(PinName Joy_n,PinName Joy_c,PinName Joy_s,PinName Joy_e,PinName Joy_w,PinName mic,PinName speaker,PinName capt_r,PinName capt_g,PinName capt_b);
    void JoyStick_Position(char pos[]);
    short * Sound_Record(short * dat);
    void Sound_Play(short * buffer);
    void PlayNote(float frequency, float duration, float volume);
    float Luminosity_Mesure();
    int setMenu();
    void printMenu(int menuitem);
    float Acc_X_Mesure();
    float Acc_Y_Mesure();
    float Acc_Z_Mesure();
    float val_lumi;
    float val_x;
    float val_y;
    float val_z;
    short dat[NUMDAT];
    char* joystickPos ;
    int select_app ;
    int menuItem ;

private:
    // Définitions des objets utiles pour la carte MyLab
    BusIn _joystick;
    AnalogIn _micro;
    AnalogOut _speaker;
    AnalogIn _r;
    AnalogIn _g;
    AnalogIn _b;
    
    
    //Timer utilise pour l'echantillonage lors d'une interruption
    Ticker Sample_Period;

    //Variable utile pour l'interruptione et la fonction PlayNote
    volatile int s;
    short unsigned Analog_out_data[32];
    short unsigned Analog_scaled_data[32];
    
    //Variable utile pour les données accéléromètre et luminosité
    float r,g,b;
    int result;
    float micCB;


    // Routine d'interruption 
    // pour l'écriture analogique sur la sortie audio lors de la
    // lecture d'un enregistrement
    
    void Sample_timer_interrupt(void) {
        _speaker.write_u16(Analog_scaled_data[s]);
        s = (s+1) & 0x01F;
    }
};



#endif /* MYLAB_LIB_MYLAB_H_ */
