/*
 * MyLab.cpp
 *  Librairie réalisé pour l'utilisation des composants de la carte d'extension MyLab
 *  
 * 
 *  Author: Favre Lucas
 */
#include "MyLab_Lib.h"
#include "mbed.h"

extern MyLab periph;

MyLab::MyLab(PinName Joy_c,PinName Joy_e,PinName Joy_n,PinName Joy_w,PinName Joy_s,PinName mic,PinName speaker,PinName capt_r,PinName capt_g,PinName capt_b) :
        _joystick (Joy_c,Joy_e,Joy_n,Joy_w,Joy_s), _micro(mic),_speaker(speaker),_r(capt_r),_g(capt_g),_b(capt_b) {
    
    
    for(int k=0; k<32; k++) {
        Analog_out_data[k] = int (65536.0 * ((1.0 + sin((float(k)/32.0*6.28318530717959)))/2.0));
    }

    Acc.init();
    joystickPos = "CENTRE";
    select_app = 0;
    menuItem=0;

}

// Lecture de la position du joystick
// sous forme de chaîne caractère

void MyLab::JoyStick_Position(char pos[]){

    result = ~_joystick.read() + 31 ;
    switch (result) {
        case 0:
            sprintf(pos,"North");
            break;
        case 1:
            sprintf(pos,"Center");
            break;
        case 7:
            sprintf(pos,"West");
            break;
        case 3:
            sprintf(pos,"South");
            break;
        case 15:
            sprintf(pos,"East");
            break;
        default:
            sprintf(pos,"");
            break;
    }
}
// Enregistrement de son sur le microphone SPU0414HR5H
short * MyLab::Sound_Record(short * dat){
        wait(1);
        micCB=0;

        for(int i=0;i<100;i++){ micCB+=_micro; }
        micCB/=100;

        // Enregistrement sur le microphone
        for(int i=0;i<NUMDAT; i++){
            dat[i]=(int)((_micro-micCB)*32768);
            wait_us(DLY);
        }
       return dat;
}
// Lecture d'un son enregistré par le microphone sur
// la sortie audio (port jack)
void MyLab::Sound_Play(short * buffer){

    for(int i=0;i<NUMDAT; i++){
        _speaker=((float)buffer[i])/32768*10+0.5;
        wait_us(DLY);
    }
}

// Génération d'une note vers la sortie audio
void MyLab::PlayNote(float frequency, float duration, float volume) {
        // scale samples using current volume level arg
        for(int k=0; k<32; k++) {
            Analog_scaled_data[k] = Analog_out_data[k] * volume;
        }
        // reset to start of sample array
        s = 0;
        // turn on timer interrupts to start sine wave output
        Sample_Period.attach(this,&MyLab::Sample_timer_interrupt, 1.0/(frequency*32.0));
        // play note for specified time
        wait(duration);
        // turns off timer interrupts
        Sample_Period.detach();
        // sets output to mid range - analog zero
        _speaker.write_u16(32768);

}
// Lecture de la valeur rgb du capteur TCS3103FN
float MyLab::Luminosity_Mesure(){
    r = _r;
    g = _g;
    b = _b;

    return r+g+b;
}


// Stockage des valeurs x y z de l'accéléromètre MMA7660FC
float MyLab::Acc_X_Mesure(){
    return Acc.read_x();
}

float MyLab::Acc_Y_Mesure(){
    return Acc.read_y();
}

float MyLab::Acc_Z_Mesure(){
    return Acc.read_z();
}

void MyLab::printMenu(int menuitem){
    lcd.cls();
       lcd.locate(0,0);
       switch (menuItem)
       {
           case 0:
               lcd.printf("mBed Librairie pour MyLab");
               lcd.locate(0,16);
               lcd.printf("Scroll with joystick");
               break;
           case 1:
               lcd.printf("Lecture de deux notes");
               lcd.locate(0,16);
               lcd.printf("Click center to Start");
               break;
           case 2:
               lcd.printf("Enregistrement audio");
               lcd.locate(0,16);
               lcd.printf("Click center to Start");
               break;
           case 3:
               lcd.printf("Lecture valeur x acc");
               lcd.locate(0,16);
               lcd.printf("Click center to Start");
               break;
           case 4:
             lcd.printf("Credits");
             lcd.locate(0,16);
             lcd.printf("Favre Lucas ITI3 Hepia ");
             break;
       }
  
}

int MyLab::setMenu()
 {
     char pos[6];
     periph.JoyStick_Position(pos);

     if (strcmp(pos,"South") == 0)
     {
         periph.joystickPos = "DOWN";
         if (periph.menuItem >= 0 && periph.menuItem < 4)
             printMenu(++periph.menuItem);
     }
     else if (strcmp(pos,"Center") == 0){
         if (periph.menuItem == 1)
             periph.select_app = 1;
         else if(periph.menuItem == 2)
             periph.select_app = 2;
         else if(periph.menuItem == 3)
             select_app = 3;
         periph.joystickPos = "CLICK";
     }
     else if (strcmp(pos,"North") == 0)
     {
         periph.joystickPos = "UP";
         if (periph.menuItem <= 4 && periph.menuItem > 0)
             printMenu(--periph.menuItem);
     }
     return periph.select_app;
 }
