/* Programme d'exemple d'utilisation de la librairie pour carte MyLabLib
 * 
 * Vous devez exporter ce programme pour l'IDE LPCXpresso 
 * 
 *
 */
#include "mbed.h"

#include "MyLab_Lib.h"

// Initialisation lcd (Pin E,Pin RW,Pin A0,Pin CS,Pin Data0...Data7)
C12832 lcd(P0_1,P0_22,P0_24,P0_0,P2_0,P2_1,P2_2,P2_3,P2_4,P2_5,P2_6,P2_7);
// Initialisation communication UART ser(Pin UART_Tx,Pin UART_RX)
Serial ser(P0_2,P0_3);
// Initialisation accéléromètre Acc(Pin I2C_SDA,Pin I2C_SCL,Adresse acc)
MMA7660FC Acc(P0_27,P0_28, ADDR_MMA7660);
// Initialisation periph pour MyLab(Pin JoyNord,Pin JoyCentre,Pin JoySud,Pin JoyEst,PinJoyWest,Pin Micro,Pin Audio_out,Pin CaptR,Pin CaptG,Pin CaptB)
MyLab periph(P2_10,P2_8,P2_12,P2_11,P2_13,P0_23,P0_26,P0_25,P1_30,P1_31);
// Initialisation led Mylab(Pin Led0..Pin Led7)
BusOut leds(P0_4,P0_5,P0_6,P0_7,P0_8,P0_9,P0_10,P0_11);


int main() {
    periph.printMenu(0);
    while(1) {

        switch (periph.setMenu()) {
            case 1:
                lcd.cls();
                lcd.locate(0,0);
                lcd.printf("Lecture de deux notes");
                periph.PlayNote(969.0, 1, 1);
                periph.PlayNote(800.0, 1, 0.5);
                wait(1);
                periph.select_app=0;
                periph.printMenu(0);
                break;
            case 2:
                lcd.cls();
                lcd.locate(0,0);
                lcd.printf("Enregistrement en cours");
                periph.Sound_Record(periph.dat);
                lcd.cls();
                lcd.locate(0,0);
                lcd.printf("Enregistrement termine");
                wait(1);
                lcd.cls();
                lcd.locate(0,0);
                lcd.printf("Lecture de l'enregistrement");
                periph.Sound_Play(periph.dat);
                wait(1);
                periph.select_app=0;
                periph.printMenu(0);
                break;
            case 3:
                lcd.cls();
                lcd.locate(0,0);
                lcd.printf("Valeur acc en x :");
                for (int var = 0; var < 200; ++var) {
                    periph.val_x = periph.Acc_X_Mesure();
                    lcd.locate(0,12);
                    lcd.printf("%f",periph.val_x);
                }
                periph.select_app=0;
                periph.printMenu(0);
                break;
        }
    }
}