/* mbed Microcontroller Library
 * Copyright (c) 2006-2015 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "mbed.h"
#include "ble/BLE.h"
#include "HeartRateService.h"
#include "BatteryService.h"
#include "DeviceInformationService.h"

Serial  pc1(USBTX, USBRX);
#define DEBUG(...) { pc1.printf(__VA_ARGS__); }

// ??? Initialize Ticker and DigitalOut objects
// 1 DigitalOut object for Led 1
// 2 Ticker objects: for aliveness and updating measurements
DigitalOut ???????????
Ticker ????????;
Ticker ????????;

// Initialize variables and tables
// Define the device name (add your group number)
const static char     ?????????[]        = "MY_BLE_HRM??";
static const uint16_t uuid16_list[]        = {GattService::UUID_HEART_RATE_SERVICE,
                                              GattService::UUID_BATTERY_SERVICE,
                                              GattService::UUID_DEVICE_INFORMATION_SERVICE};

// ??? define flag for measurement updating
static volatile bool  ?????????????????????????

void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params)
{
    DEBUG("Disconnected!\n\r");
    DEBUG("Restarting the advertising process\n\r");
    (void)params;
      // ??? Restart advertising
      ??????????????????????????
}

// Connection Handler
void connectionCallback(const Gap::ConnectionCallbackParams_t *params)
{
    DEBUG("Connected\r\n");
}

// ??? Define update Characteristics Handler update_handler
// It must set the flag for update the heart rate
void ???????????(void)
{    
      ??????????????????????????
}

// ??? Define the Aliveness Handler, it must toggle the led 1
void aliveness_handler (void)
{   
      ????????????????????????
}


void onBleInitError(BLE &ble, ble_error_t error)
{
    (void)ble;
    (void)error;
   /* Initialization error handling should go here */
}

void bleInitComplete(BLE::InitializationCompleteCallbackContext *params)
{
    BLE&        ble   = params->ble;
    ble_error_t error = params->error;
    
    // ??? Attach ticker objects to functions
    // Two handlers:
    // 1. aliveness_handler, with 500 ms timing, which toggles led1
    // 2. update_handler, with 2 s timing, which sets a flag for the heart rate updating
        ???????????????????????????
        ???????????????????????????

    DEBUG("Initialising \n\r");

    if (error != BLE_ERROR_NONE) {
        onBleInitError(ble, error);
        return;
    }

    if (ble.getInstanceID() != BLE::DEFAULT_INSTANCE) {
        return;
    }

    ble.gap().onDisconnection(disconnectionCallback);
    ble.gap().onConnection(connectionCallback);
    
        // Setup BLE device services

    /* ??? Setup primary service. */
    // Define and init variable for heart rate simulation (it can be a uint8_t)
    uint8_t ????????????????? = ???;
    /* Declare and init (call constructor) HeartRateService object
     * Constructor is:
     * HeartRateService(BLE &_ble, uint8_t hrmCounter, uint8_t location) 
     * for location you can use HeartRateService::LOCATION_FINGER */
    HeartRateService ????????????????;
    
    /* ??? Setup battery level service. */
    // Define and init variable for battery level simulation (it can be a uint8_t)
    uint8_t ?????????? = ???;
    /* Declare and init (call constructor) BatteryService object
     * Constructor is:
     * BatteryService(BLE &_ble, uint8_t level = 100) */
    BatteryService   ????????????????;
    /* Declare and init (call constructor) DeviceInformationService object
     * Constructor is:
     * DeviceInformationService(BLE        &_ble,
                         const char *manufacturersName = NULL,
                         const char *modelNumber       = NULL,
                         const char *serialNumber      = NULL,
                         const char *hardwareRevision  = NULL,
                         const char *firmwareRevision  = NULL,
                         const char *softwareRevision  = NULL) 
     * You can use manufacturerName = "ST", modelNumber = "Nucleo", serialNumber = "SN1"*/
    DeviceInformationService ???????????????;

    /* Setup advertising. */
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);
    // ??? Add the complete list of services provided to the advertising payload (GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS)
    ble.gap().??????????????????????????????????
    // ??? Add the heart rate service to the advertising payload (GapAdvertisingData::GENERIC_HEART_RATE_SENSOR)
    ble.gap().??????????????????????????????????
    // ??? Add the device name to the advertising payload (GapAdvertisingData::COMPLETE_LOCAL_NAME)
    ble.gap().??????????????????????????????????
    ble.gap().setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    // Set advertising interval to 1 s
    ble.gap().??????????????????????????????????
    // ??? Start advertising, call the appropriate methods of the GAP object
    ble.gap().????????????????;

    // infinite loop
    while (true) {
        // check for  from update_handler()
        if (???????????????????? && ble.getGapState().connected) {
            //??? Reset flag
            ?????????????????????
            
            // ??? Update the heart rate counter
            // increase by 1. If equal to 150, then reset to 80
            ?????????????
            ?????????????
            ?????????????
            ?????????????

            // ??? Update value of heart rate service
            ?????????????????????????
        } else {
            ble.waitForEvent(); // low power wait for event
        }
    }
}

int main(void)
{
    BLE::Instance().init(bleInitComplete);
}

