#include "mbed.h"

// DEFINE AN ARRAY FOR EACH COMMAND YOU NEED, IT CONTAINS A SEQUENCE OF VALUE FOR EACH COMMAND WE NEED, 
// SEE DOCUMENTATION: COMMAND PROTOCOL DETAILS

int ARRAY_SOURCE[] = {342,171,21,64,21,21,21,21,21,64,21,64,21,64,21,21,21,64,21,21,21,64,21,64,21,21,21,21,21,21,21,64,21,21,21,64,21,64,21,21,21,21,21,64,21,21,21,21,21,21,21,21,21,21,21,64,21,64,21,21,21,64,21,64,21,64,21};
int ARRAY_TEL[] = {342,171,21,64,21,21,21,21,21,64,21,64,21,64,21,21,21,64,21,21,21,64,21,64,21,21,21,21,21,21,21,64,21,21,21,21,21,64,21,21,21,21,21,64,21,21,21,21,21,64,21,64,21,21,21,64,21,64,21,21,21,64,21,64,21,21,21};
int ARRAY_VOLUP[] = {342,171,21,64,21,21,21,21,21,64,21,64,21,64,21,21,21,64,21,21,21,64,21,64,21,21,21,21,21,21,21,64,21,21,21,21,21,21,21,64,21,21,21,64,21,21,21,21,21,21,21,64,21,64,21,21,21,64,21,21,21,64,21,64,21,64,21,1};
int ARRAY_VOLDWN[] = {342,171,21,64,21,21,21,21,21,64,21,64,21,64,21,21,21,64,21,21,21,64,21,64,21,21,21,21,21,21,21,64,21,21,21,64,21,21,21,64,21,21,21,64,21,21,21,21,21,21,21,21,21,64,21,21,21,64,21,21,21,64,21,64,21,64,21};
int ARRAY_FF[] = {342,171,21,64,21,21,21,21,21,64,21,64,21,64,21,21,21,64,21,21,21,64,21,64,21,21,21,21,21,21,21,64,21,21,21,64,21,64,21,21,21,64,21,21,21,21,21,21,21,21,21,21,21,21,21,64,21,21,21,64,21,64,21,64,21,64,21};
int ARRAY_RR[] = {342,171,21,64,21,21,21,21,21,64,21,64,21,64,21,21,21,64,21,21,21,64,21,64,21,21,21,21,21,21,21,64,21,21,21,21,21,64,21,21,21,64,21,21,21,21,21,21,21,21,21,64,21,21,21,64,21,21,21,64,21,64,21,64,21,64,21};
int ARRAY_ROTUP[] = {342,171,21,64,21,21,21,21,21,64,21,64,21,64,21,21,21,64,21,21,21,64,21,64,21,21,21,21,21,21,21,64,21,21,21,64,21,21,21,64,21,64,21,21,21,21,21,21,21,21,21,21,21,64,21,21,21,21,21,64,21,64,21,64,21,64,21};
int ARRAY_ROTDWN[] = {342,171,21,64,21,21,21,21,21,64,21,64,21,64,21,21,21,64,21,21,21,64,21,64,21,21,21,21,21,21,21,64,21,21,21,21,21,21,21,64,21,64,21,21,21,21,21,21,21,21,21,64,21,64,21,21,21,21,21,64,21,64,21,64,21,64,21};
    
//DEFINE MY OUTPUTS: "led" is IRLED (anode connected on PC_0, catode on GND), "myled" is STM32 NUCLEO board-led
DigitalOut myled(LED1);
DigitalOut led(PC_0);


//Define an input port for each command
DigitalIn pushButton1(PC_1); //connect "SOURCE" steering wheel controls button to STMF401RE  PC_1 port
DigitalIn pushButton2(PC_2); //connect "TEL" steering wheel controls button to STMF401RE  PC_2 port
DigitalIn pushButton3(PC_3); //connect "VOLUP" steering wheel controls button to STMF401RE  PC_3 port
DigitalIn pushButton4(PC_4); //connect "VOLDWN" steering wheel controls button to STMF401RE  PC_4 port
DigitalIn pushButton5(PC_5); //connect "FF" steering wheel controls button to STMF401RE  PC_5 port
DigitalIn pushButton6(PC_6); //connect "RR" steering wheel controls button to STMF401RE  PC_6 port
DigitalIn pushButton7(PC_7); //connect "ROTUP" steering wheel controls button to STMF401RE  PC_7 port
DigitalIn pushButton8(PC_8); //connect "ROTDWN" steering wheel controls button to STMF401RE  PC_8 port


//int x;

// Main Loop runs in its own thread in the OS
int main() {
   
    // Active Pull-Up Resistor
    pushButton1.mode(PullDown);
    pushButton2.mode(PullDown);
    pushButton3.mode(PullDown);
    pushButton4.mode(PullDown);
    pushButton5.mode(PullDown);
    pushButton6.mode(PullDown);
    pushButton7.mode(PullDown);
    pushButton8.mode(PullDown);
    // Inifite Loop

  while(1) {

// DEFINE for each button pressed which is the array to send
int ARRAY_SEND[67];
int i;
 if(pushButton1 == 1)  { for (i=0;i<67;i++) {ARRAY_SEND[i]=ARRAY_SOURCE[i];} }
  else if(pushButton2 == 1)  { for (i=0;i<67;i++) {ARRAY_SEND[i]=ARRAY_TEL[i];} }
  else if(pushButton3 == 1)  { for (i=0;i<67;i++) {ARRAY_SEND[i]=ARRAY_VOLUP[i];} }      
  else if(pushButton4 == 1)  { for (i=0;i<67;i++) {ARRAY_SEND[i]=ARRAY_VOLDWN[i];} }    
  else if(pushButton5 == 1)  { for (i=0;i<67;i++) {ARRAY_SEND[i]=ARRAY_FF[i];} } 
  else if(pushButton6 == 1)  { for (i=0;i<67;i++) {ARRAY_SEND[i]=ARRAY_RR[i];} }
  else if(pushButton7 == 1)  { for (i=0;i<67;i++) {ARRAY_SEND[i]=ARRAY_ROTUP[i];} }
  else if(pushButton8 == 1)  { for (i=0;i<67;i++) {ARRAY_SEND[i]=ARRAY_ROTDWN[i];} } 
// IF any button is pressed the outputs level is 0
        else {
            // LEDs Turn-Off
            led = 0;
            myled =0;            
        }
//If a button is 1 CREATE A IRPULSE WAVEFORM THAT FOLLOW THE ARRAY_SEND
if (pushButton1==1 || pushButton2 ==1 || pushButton3 ==1 || pushButton4 ==1 || pushButton5 ==1 || pushButton6 ==1 || pushButton7 ==1 || pushButton8 ==1 ) {
//From BIT 0 to the final BIT OF ARRAYSEND
int BIT,n;
for (BIT = 0; BIT < 67; BIT ++) {
//if the position of BIT in ARRAYSEND is even, turn on/off the IRLED and BOARD LED following a 38000Hz modulation(13usON/13usOFF) for a number of cicles = BIT value 
  if ( BIT % 2==0) {  
  for (n =1; n <= ARRAY_SEND[BIT]; n++){         
             myled =1;
            led =1;
             wait_us (13);
            myled =0;
            led =0;
            wait_us (13);
             }}
//if the position of BIT in ARRAYSEND is odd, turn off the IRLED and BOARD LED following a 38000Hz modulation(13us+13us=26us OFF) for a number of cicles = BIT value 
  else {            
    for (n =1; n <= ARRAY_SEND[BIT]; n++){         
             myled =0;
            led =0;
            wait_us (26);
             }}
 } // end for
 //PUT 100000us OFF at the end of ARRAY_SEND IRPULSE WAVEFORM 
             myled =0;
             led =0;
             wait_us (110000);
} // end if
} //end while
} //end main