//PROGRAMA PARA CONTROLAR EL VOLTAJE DE UN CAPACITOR EN UN CIRCUITO RC DESDE DISPOSITIVO ANDROID
//ENVIAR LOS VALORES SEPARADOS POR COMAS
#include "mbed.h"              
#include "stdio.h"
#include "string.h"
#include "stdlib.h"

//Variables y parametros del control PID
int Kp=0,Ki=0,Kd=0;
float Sp=0;//set point
float ai,ek,ad,ap,err_v,o,yT,uk=0,Ts=0.01;

AnalogIn   Vc(PTB0);//voltaje condensador
PwmOut  uc(PTE20); //accion de control
Serial GSM(PTE0,PTE1);  //puertos del FRDM para el modulo BLUETOOTH
Serial pc(USBTX,USBRX); //puertos del PC
char buffer[30];// TAMAÑO DEL BUFER
Timer t;   //VALOR DEL TIEMPO
int count;
int i = 0;
int c=0;
char r[]=""; 
DigitalOut LedRojo(LED1);
DigitalOut LedVerde(LED2);
DigitalOut LedAzul(LED3);

int readBuffer(char *buffer,int count)   //esta funcion lee un bufer de datos
{
    int i=0; 
    t.start();    //CUENTA EL TIEMPO DE CONEXION E INICIA
    while(1) {
        while (GSM.readable()) {
            char c = GSM.getc();
            if (c == '\r' || c == '\n') c = '$';//si se envia fin de linea o de caracter inserta $
            buffer[i++] = c;//mete al bufer el caracter leido
            if(i > count)break;//sale del loop si ya detecto terminacion
        }
        if(i > count)break;
        if(t.read() > 1) {  //MAS DE UN SEGUNDO DE ESPERA SE SALE Y REINICA EL RELOJ Y SE SALE
            t.stop();
            t.reset();
            break;
        }
    }
     return 0;
}
 
void cleanBuffer(char *buffer, int count)  //esta funcion limpia el bufer
{
    for(int i=0; i < count; i++) {
        buffer[i] = '\0';
    }
}
int main() {
    
       LedVerde=1;
       LedRojo=1;
       LedAzul=1;
       LedRojo=0;
       wait(2);   //PRENDE EL LED ROJO POR 2 SEGUNDOS
       LedRojo=1;
       GSM.baud(9600);
       GSM.format(8,Serial::None,1); 
       
    GSM.printf("Enviar los valores Kp,Ki,Kd,Sp separados por comas           \n");
     
    DEF_CONST: 
        
       if (GSM.readable()) {
          readBuffer(buffer,20);
          GSM.printf("Enviar los valores Kp,Ki,Kd,Sp separados por comas           \n");
          sscanf( buffer, "%d, %d, %d, %f", &Kp, &Ki, &Kd, &Sp);
          GSM.printf("%d, %d, %d, %.1f\n", Kp,Ki,Kd,Sp);
          }
        
    if(Kp == 0){
    goto DEF_CONST;
    }else{
    goto PID;
    }
        
    PID: 
    
    
    while(1){
    yT=Vc.read()*3.3;
    ek=Sp-yT;
     
    ap = Kp*ek*0.01f;     //se calcula la accion proporcinal
    ai =(Ki*ek*0.01f)+ai;    //calculo de la integral del error
    ad = Kd*(ek-err_v)*0.01f; //calculo de la accion derivativa
    uk = (ap+ai+ad);
    
    // se verifica que pid sea positivo **************************************
        if(uk<=0)
        {
            uk=0;
        }
 
        // se verifica que pid sea menor o igual la valor maximo *****************
        if (uk > 3.3)
        {
            uk=3.3;
        }
     //Normalizacion de la salida
        // se actualizan las variables *******************************************
        err_v = ek;
        o = uk/3.3;
        uc.write(o);
        //  se envia el valor pid a puerto analogico de salida (D/A) **************
        
        //  se repite el ciclo
        wait(Ts);
              
        //Mostrando error y salida actual
  
        GSM.printf("Error= %.2f\t",ek);
        GSM.printf("Set Point= %.1f\t",Sp);
        GSM.printf("Voltaje Actual= %.1f\n",yT);
        wait(Ts); //Tiempo de muestreo
              
        }
   
}    
        
                        
           
   
    
    
                        
           